<?php
App::uses('AppController', 'Controller');
class SellersController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('Seller','EmailTemplate','ApplicationSetting','SellerBankDetail','SellerCompanyInformation','SellerOpeningTime','SellerPaymentMethod','SellerSellingPoint','Payment','MileagePrice','MileageRate','HourlyFair'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'Seller.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	
	public function admin_index($id = null) {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->Seller->recursive = 0;
		if ($this->request->is('post')) {
			if($this->request->data['task_value']=='DeActive')
				$this->Seller->updateAll(array("Seller.status"=>'0'),array("Seller.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
			{
				$this->Seller->updateAll(array("Seller.status"=>'1'),array("Seller.id"=>$this->request->data['frmList']['ID']));
				foreach($this->request->data['frmList']['ID'] as $userid)
				{
					$this->add_seller_data($userid);
				}
			}
			else if($this->request->data['task_value']=='Delete')
				$this->Seller->deleteAll(array('Seller.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		if(isset($this->data['Seller']['first_name']) && $this->data['Seller']['first_name']!='') $first_name = $this->data['Seller']['first_name'];	
		else if(isset($this->params['named']['first_name']) && $this->params['named']['first_name']!='') $first_name = $this->request->data['Seller']['first_name']=$this->params['named']['first_name'];
		
		if(isset($this->data['Seller']['last_name']) && $this->data['Seller']['last_name']!='') $last_name = $this->data['Seller']['last_name'];	
		else if(isset($this->params['named']['last_name']) && $this->params['named']['last_name']!='') $last_name = $this->request->data['Seller']['last_name']=$this->params['named']['last_name'];
		
		if(isset($this->data['Seller']['email']) && $this->data['Seller']['email']!='') $email = $this->data['Seller']['email'];	
		else if(isset($this->params['named']['email']) && $this->params['named']['email']!='') $email = $this->request->data['Seller']['email']=$this->params['named']['email'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($first_name))
		{
			$conditions['Seller.first_name LIKE '] = '%'.$first_name.'%';
			$pagingArgs['first_name'] = $first_name;
		}
		if(!empty($last_name))
		{
			$conditions['Seller.last_name LIKE '] = '%'.$last_name.'%';
			$pagingArgs['last_name'] = $last_name;
		}
		if(!empty($email))
		{
			$conditions['Seller.email LIKE '] = '%'.$email.'%';
			$pagingArgs['email'] = $email;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$conditions['Seller.role'] = 3; 
		$limit=$this->get_application_setting('result_limit');		
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('Seller.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('sellers', $rows);
		
		$this->params['page_title'] = "Sub Admin";
		if($id != null){
		$this->Seller->id = $id;
		if (!$this->Seller->exists()) {
			throw new NotFoundException(__('Invalid seller'));
		}
		
		$this->request->data = $this->Seller->read(null, $id);
		unset($this->request->data['Seller']['password']);
		}
	}
	public function admin_add() {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Add Seller'));
		if ($this->request->is('post')) {
			$this->Seller->create();
			
			$sellerdata['first_name']	=	$this->request->data['Seller']['first_name'];
			$sellerdata['last_name']	=	$this->request->data['Seller']['last_name'];
			$sellerdata['email']		=	$this->request->data['Seller']['email'];
			$sellerdata['username']	=	$this->request->data['Seller']['email'];
			$sellerdata['password']	=	$this->request->data['Seller']['password'];
			$sellerdata['address']	=	$this->request->data['Seller']['address'];
			$sellerdata['phone']		=	$this->request->data['Seller']['phone'];
			$sellerdata['date']			=	3;
			$sellerdata['date']			=	date("Y-m-d H:i:s");
			if ($res=$this->Seller->save($sellerdata)){				
				$this->Session->setFlash(__('Sub admin has been added successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('Sub admin could not be added.'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
		}
	}
	public function admin_edit($id = null) {
		$this->checkAdmin();
		$this->set('title_for_layout', __('Edit Seller'));
		$this->Seller->id = $id;
		$selected = "";
		
		$driver_detail = $this->Seller->find("first",array("conditions"=>array("Seller.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		
		if (!$this->Seller->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['Seller']['id']=$id;		
			pr($this->request->data['Seller']);	
			if ($res=$this->Seller->saveAll($this->request->data['Seller'])) {
				$this->Session->setFlash(__('Seller has been updated successfully.'), 'default', array('class' => 'success'));
			} else {
				
			}
			$this->request->data = $this->Seller->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->Seller->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function resetpassword($token = NULL){
		$this->layout = 'admin_login';
		if(empty($this->data)){	
			if(isset($this->params['pass'][0])){
				if(!empty($this->params['pass'][0])){
					$data = $this->Seller->find('first',array('conditions'=>array('Seller.reset_token'=>$this->params['pass'][0]),'fields'=>array('Seller.id')));
					if(empty($data)){
						$this->Session->setFlash(__('Invalid link, Either token has been expired or invalid token.'), 'default', array('class' => 'success'));
						//$this->redirect(array('controller'=>'admin/users','action' => 'login'));
					}
				}
				else{
					$this->Session->setFlash(__('Invalid link, Either token has been expired or invalid token.'), 'default', array('class' => 'success'));
					//$this->redirect(array('controller'=>'admin/users','action' => 'login'));
				}
			}
			else{
				$this->Session->setFlash(__('Invalid link, Either token has been expired or invalid token.'), 'default', array('class' => 'success'));
				//$this->redirect(array('controller'=>'admin/users','action' => 'login'));
			}
		}
		else{
			$data = $this->Seller->find('first',array('conditions'=>array('Seller.reset_token'=>$this->params['pass'][0]),'fields'=>array('Seller.id')));
			if(!empty($data)){
				$this->request->data['Seller']['id'] = $data['Seller']['id'];
				$this->request->data['Seller']['password'] = $this->request->data['Seller']['password'];
				$this->request->data['Seller']['reset_token'] = '';
				if ($this->Seller->save($this->request->data)) {
					$this->Session->setFlash(__('Your password has been reset sucessfully.'), 'default', array('class' => 'success'));
					//$this->redirect(array('controller'=>'admin/users','action' => 'login'));
				}
				else{
					$this->Session->setFlash(__('Invalid link, Either token has been expired or invalid token.'), 'default', array('class' => 'success'));
					//$this->redirect(array('controller'=>'admin/users','action' => 'login'));
				}
				
			}
			else{
					$this->Session->setFlash(__('Invalid link, Either token has been expired or invalid token.'), 'default', array('class' => 'success'));
					//$this->redirect(array('controller'=>'admin/users','action' => 'login'));
				}
		}
		
				
	}
	
	public function activate_account($id = NULL){
		$this->layout = NULL;
		$data = $this->Seller->find('first',array('conditions'=>array('Seller.activation_token'=>$this->params['pass'][0]),'fields'=>array('Seller.id')));
		if(!empty($data)){
			$this->request->data['Seller']['id'] = $data['Seller']['id'];
			$this->request->data['Seller']['status'] = 1;
			$this->request->data['Seller']['activation_token'] ='';
			if ($this->Seller->save($this->request->data)) {
				$this->Session->setFlash(__('Your account has been activated.'), 'default', array('class' => 'success'));
				$this->redirect(array('controller'=>'admin/users','action' => 'login'));
			}
			else{
				$this->Session->setFlash(__('Invalid link, Either user has been deleted.'), 'default', array('class' => 'success'));
				$this->redirect(array('controller'=>'admin/users','action' => 'login'));
			}
		}
		else{
				$this->Session->setFlash(__('Invalid link, Either user has been deleted.'), 'default', array('class' => 'success'));
				$this->redirect(array('controller'=>'admin/users','action' => 'login'));
			}
	}	
	public function dashboard() {
		
		$this->checkSeller();
		$this->layout='seller';
		$user_id = $this->Auth->user('id');		
		$this->Seller->id = $user_id;
		if (!$this->Seller->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->Seller->save($this->request->data)) {
				
				$this->Session->setFlash(__('Profile has been updated successfully.'), 'default', array('class' => 'success'));
			} else {
				$this->Session->setFlash(__('Profile could not be saved. Please, try again.'), 'default', array('class' => 'success'));
			}
		} 
		$seller_data= $this->Seller->read(null, $user_id);
		$this->set("seller_data",$seller_data['Seller']);
		
		if(isset($this->data['Payment']['order_no']) && $this->data['Payment']['order_no']!='') $order_no = $this->data['Payment']['order_no'];	
		else if(isset($this->params['named']['order_no']) && $this->params['named']['order_no']!='') $order_no = $this->request->data['Payment']['order_no']=$this->params['named']['order_no'];
		
		if(isset($this->data['Payment']['fromdate']) && $this->data['Payment']['fromdate']!='') $fromdate = $this->data['Payment']['fromdate'];	
		else if(isset($this->params['named']['fromdate']) && $this->params['named']['fromdate']!='') $fromdate = $this->request->data['Seller']['fromdate']=$this->params['named']['fromdate'];
		
		if(isset($this->data['Payment']['todate']) && $this->data['Payment']['todate']!='') $todate = $this->data['Payment']['todate'];	
		else if(isset($this->params['named']['todate']) && $this->params['named']['todate']!='') $todate = $this->request->data['Seller']['todate']=$this->params['named']['todate'];
		
		$conditions = array("Payment.user_id"=>$this->Auth->user('id')); 
		$pagingArgs = array(); 
		if(!empty($order_no))
		{
			$conditions['Payment.order_no'] =$order_no;
			$pagingArgs['order_no'] = $order_no;
		}
		if(!empty($fromdate))
		{
			$conditions['Payment.order_date > '] = $fromdate;
			$pagingArgs['fromdate'] = $fromdate;
		}
		if(!empty($todate))
		{
			$conditions['Payment.order_date < '] = $todate;
			$pagingArgs['todate'] = $todate;
		}
		$this->Payment->recursive=0;
		$payments=$this->Payment->find("all",array("conditions"=>$conditions,'fields'=>array('CustomerDetail.name','CustomerDetail.id','Payment.*'), "order"=>"Payment.id desc","limit"=>"20"));
		$this->set("payments",$payments);
	}
	public function change_password() {
		$this->checkSeller();
		$user_id = $this->Auth->user('id');
		$this->Seller->id = $user_id;
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['Seller']['id']=$user_id;
			
			$user_detail=$this->Seller->find("first",array("conditions"=>array("Seller.id"=>$this->Auth->user('id'))));
			$old_password=Security::hash($this->request->data['Seller']['opassword'], null, TRUE);
			
			if($old_password == $user_detail['Seller']['password'])
			{
				unset($this->request->data['Seller']['opassword']);
				unset($this->request->data['Seller']['cpassword']);
				$this->request->data['Seller']['id']=$user_id;
				//pr($this->request->data);die;
				if ($this->Seller->saveAll($this->request->data)) {
					$this->Session->setFlash(__('The password has been updated sucessfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'change_password'));
				} else {
					
				}
				$this->request->data = $this->Seller->read(null, $user_id);
			}
			else
			{
				$this->Session->setFlash(__('The password could not be updated sucessfully.'), 'default', array('class' => 'success'));
				$this->redirect(array("action"=>"change_password"));
			}
		} else {
			$this->request->data = $this->Seller->read(null, $user_id);
			unset($this->request->data['Seller']['password']);
		}
	}
	public function edit_account()
	{
		$this->checkSeller();
		$user_id = $this->Auth->user('id');
		$this->Seller->id = $user_id;
	}
	public function bank_details()
	{
		$this->checkSeller();
		$this->layout='seller';
		$user_id = $this->Auth->user('id');
		if ($this->request->is('post') || $this->request->is('put')) {
			$bank_detail=$this->SellerBankDetail->find("first",array("Conditions"=>array("SellerBankDetail.user_id"=>$user_id)));
			if(!empty($bank_detail))
				$this->request->data['SellerBankDetail']['id']=$bank_detail['SellerBankDetail']['id'];
			$this->request->data['SellerBankDetail']['user_id']=$this->Auth->user('id');
			
			if ($this->SellerBankDetail->save($this->request->data['SellerBankDetail'])) {				
				$this->Session->setFlash(__('Bank details has been updated successfully.'), 'default', array('class' => 'success'));
			} else {
				$this->Session->setFlash(__('Bank details could not be saved. Please, try again.'), 'default', array('class' => 'error'));
			}			
		}
		$bank_detail=$this->SellerBankDetail->find("first",array("Conditions"=>array("SellerBankDetail.user_id"=>$user_id)));
		$this->set("bank_detail",$bank_detail);
	}
	public function company_information()
	{
		$this->checkSeller();
		$this->layout='seller';
		$user_id = $this->Auth->user('id');
		if ($this->request->is('post') || $this->request->is('put')) {
			$company_information=$this->SellerCompanyInformation->find("first",array("Conditions"=>array("SellerCompanyInformation.user_id"=>$user_id)));
			
						
			if(!empty($company_information))
				$this->request->data['SellerCompanyInformation']['id']=$company_information['SellerCompanyInformation']['id'];
				$this->request->data['SellerCompanyInformation']['user_id']=$this->Auth->user('id');
				$imagedata='';
				if(isset($this->request->data['SellerCompanyInformation']['company_logo']))
				{
					$imagedata = $this->request->data['SellerCompanyInformation']['company_logo'];
					unset($this->request->data['SellerCompanyInformation']['company_logo']);
				}
			if ($res=$this->SellerCompanyInformation->save($this->request->data['SellerCompanyInformation'])) {	
				if(!empty($imagedata))
				{		
					if(!empty($this->request->data['SellerCompanyInformation']['pre_img']))
					{
						unlink(WWW_ROOT.'company_logo/'.$this->request->data['SellerCompanyInformation']['pre_img']);
					}
					$img=$this->uploadfile($imagedata,'company_logo',"SellerCompanyInformation",'company_logo',$res['SellerCompanyInformation']['id']);
					$file_arr1['id']=$res['SellerCompanyInformation']['id'];
					$file_arr1['company_logo']=$img;
					$res_provide=$this->SellerCompanyInformation->save($file_arr1);
				}
				// Save opening time
				//pr($this->request->data['OpeningTime']);die;
				if(isset($this->request->data['OpeningTime']['opening_day']))
				{
					$pre_opening_day=array();
					foreach($this->request->data['OpeningTime']['opening_day'] as $open_key=>$opening_day)
					{
						$opening_arr=array();
						$opening_arr['id']='';
						$opening_arr['user_id']=$this->Auth->user('id');
						$opening_arr['opening_day']=$opening_day;
						$opening_arr['from_time']=$this->request->data['OpeningTime']['from_time'][$open_key];
						$opening_arr['to_time']=$this->request->data['OpeningTime']['to_time'][$open_key];
						$opening_arr['full_day']=$this->request->data['OpeningTime']['full_day'][$open_key];
						$check_pre=$this->check_opening_time($this->Auth->user('id'),$opening_day);
						if(!empty($check_pre))
							$opening_arr['id']=$check_pre;
						$this->SellerOpeningTime->save($opening_arr);
						$pre_opening_day[]=$opening_day;
					}
					// delete unchecked opening time
					$this->SellerOpeningTime->deleteAll(array('SellerOpeningTime.user_id' => $this->Auth->user('id'),'SellerOpeningTime.opening_day not '=>$pre_opening_day), false);
				}
				if(isset($this->request->data['SellingPoint']['selling_points_id']))
				{
					$pre_selling_points=array();
					foreach($this->request->data['SellingPoint']['selling_points_id'] as $open_key=>$selling_points_id)
					{
						$selling_points_arr=array();
						$selling_points_arr['id']='';
						$selling_points_arr['user_id']=$this->Auth->user('id');
						$selling_points_arr['selling_points_id']=$selling_points_id;
						
						$check_pre=$this->check_selling_point($this->Auth->user('id'),$selling_points_id);
						if(!empty($check_pre))
							$selling_points_arr['id']=$check_pre;
						$this->SellerSellingPoint->save($selling_points_arr);
						$pre_selling_points[]=$selling_points_id;
					}
					// delete unchecked opening time
					$this->SellerSellingPoint->deleteAll(array('SellerSellingPoint.user_id' => $this->Auth->user('id'),'SellerSellingPoint.selling_points_id not '=>$pre_selling_points), false);
				}
				if(isset($this->request->data['PaymentMethod']['payment_method_id']))
				{
					$pre_payment_method=array();
					foreach($this->request->data['PaymentMethod']['payment_method_id'] as $open_key=>$payment_method_id)
					{
						$payment_method_arr=array();
						$payment_method_arr['id']='';
						$payment_method_arr['user_id']=$this->Auth->user('id');
						$payment_method_arr['payment_method_id']=$payment_method_id;
						
						$check_pre=$this->check_payment_method($this->Auth->user('id'),$payment_method_id);
						if(!empty($check_pre))
							$payment_method_arr['id']=$check_pre;
						$this->SellerPaymentMethod->save($payment_method_arr);
						$pre_payment_method[]=$payment_method_id;
					}
					// delete unchecked opening time
					$this->SellerPaymentMethod->deleteAll(array('SellerPaymentMethod.user_id' => $this->Auth->user('id'),'SellerPaymentMethod.payment_method_id not '=>$pre_payment_method), false);
				}
				$this->Session->setFlash(__('Company information has been updated successfully.'), 'default', array('class' => 'success'));
			} else {
				$this->Session->setFlash(__('Company information could not be saved. Please, try again.'), 'default', array('class' => 'error'));
			}			
		}
		$this->request->data=$this->SellerCompanyInformation->find("first",array("Conditions"=>array("SellerCompanyInformation.user_id"=>$user_id)));
		$this->set("company_information",$this->request->data);
	}
	public function seller_mileage($vehicle_type=1)
	{
		$this->checkSeller();
		$this->layout='seller';
		$user_id = $this->Auth->user('id');
		if($vehicle_type==4)
			$last=4;
		else if($vehicle_type==3)
			$last=5;
		else
			$last=8;
		if ($this->request->is('post') || $this->request->is('put')) {
			$company_information=$this->SellerCompanyInformation->find("first",array("Conditions"=>array("SellerCompanyInformation.user_id"=>$user_id)));
			$this->MileagePrice->save($this->request->data['MileagePrice']);
			$this->request->data['SellerCompanyInformation']['id']=$company_information['SellerCompanyInformation']['id'];
			$this->SellerCompanyInformation->save($this->request->data['SellerCompanyInformation']);
			foreach($this->request->data['MileageRate']['mileage_rate_id'] as $val)
			{
				$arr_rates=array();
				$arr_rates['id']=$val;
				$arr_rates['distance_to']=$this->request->data['MileageRate']['distance_to'][$val];
				$arr_rates['saloon']=$this->request->data['MileageRate']['saloon'][$val];
				for($k=1;$k<=$last;$k++)
				{
					$this->request->data['MileageRate']['saloon'][$val].'=>'.$this->request->data['MileageRate']['distance_to'][$val].'=>'.$this->request->data['MileagePrice']['passenger'.$k.'_percentage'].'<br>';
					if(!empty($this->request->data['MileageRate']['saloon'][$val]) && !empty($this->request->data['MileageRate']['distance_to'][$val]))
					{
						if($this->request->data['MileagePrice']['passenger'.$k.'_type']==1)
						{
							$price=$this->request->data['MileageRate']['saloon'][$val]+($this->request->data['MileageRate']['saloon'][$val]*$this->request->data['MileagePrice']['passenger'.$k.'_percentage']/100);
							$arr_rates['passenger'.$k]=$price;
						}
						else if($this->request->data['MileagePrice']['passenger'.$k.'_type']==2)
						{
							$price=$this->request->data['MileageRate']['saloon'][$val]+$this->request->data['MileagePrice']['passenger'.$k.'_amount'];
							$arr_rates['passenger'.$k]=$price;
						}
					}
					else
						$arr_rates['passenger'.$k]='';
				}
				
				$this->MileageRate->save($arr_rates);
			}
		}
		$rows=$this->request->data=$this->MileagePrice->find("first",array("conditions"=>array("MileagePrice.user_id"=>$user_id,"MileagePrice.vehicle_type"=>$vehicle_type)));
		$this->set('mileage_prices', $rows);
		$mileage_rates=$this->MileageRate->find("all",array("conditions"=>array("MileageRate.mileage_price_id"=>$rows['MileagePrice']['id'])));
		$this->set('mileage_rates', $mileage_rates);
		$this->set('vehicle_type', $vehicle_type);
		$company_information=$this->SellerCompanyInformation->find("first",array("Conditions"=>array("SellerCompanyInformation.user_id"=>$user_id)));
		$this->request->data['SellerCompanyInformation']=$company_information['SellerCompanyInformation'];
		//pr($this->request->data);
	}
	public function seller_airport_discount()
	{
		$this->checkSeller();
		$this->layout='seller';
		$user_id = $this->Auth->user('id');
		if ($this->request->is('post') || $this->request->is('put')) {
			$company_information=$this->SellerCompanyInformation->find("first",array("Conditions"=>array("SellerCompanyInformation.user_id"=>$user_id)));
			if(!empty($company_information))
				$this->request->data['SellerCompanyInformation']['id']=$company_information['SellerCompanyInformation']['id'];
				$this->request->data['SellerCompanyInformation']['user_id']=$this->Auth->user('id');
				
			if ($res=$this->SellerCompanyInformation->save($this->request->data['SellerCompanyInformation'])) {	
				$this->Session->setFlash(__('Airport Discount has been updated successfully.'), 'default', array('class' => 'success'));
			} else {
				$this->Session->setFlash(__('Airport Discount could not be saved. Please, try again.'), 'default', array('class' => 'error'));
			}			
		}
		$this->request->data=$this->SellerCompanyInformation->find("first",array("Conditions"=>array("SellerCompanyInformation.user_id"=>$user_id)));
		$this->set("company_information",$this->request->data);
	}
	public function add_customer()
	{
		$this->checkSeller();
		$this->layout='seller';
		$user_id = $this->Auth->user('id');
		if ($this->request->is('post') || $this->request->is('put')) {
			if(!empty($company_information))
				$this->request->data['Seller']['added_by']=$this->Auth->user('id');	
				$pass=$this->generateRandomString(6);
				$this->request->data['Seller']['password']=$pass;
				$this->request->data['Seller']['username']=$this->request->data['Seller']['email'];
			if ($res=$this->Seller->save($this->request->data['Seller'])) {	
				$this->Session->setFlash(__('Customer has been added successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'add_customer'));
			} else {
				$this->Session->setFlash(__('Customer could not be saved. Please, try again.'), 'default', array('class' => 'error'));
			}			
		}
	}
	public function order_history()
	{
		$this->checkSeller();
		$user_id = $this->Auth->user('id');
		$this->Seller->id = $user_id;
	}
	public function thank_you()
	{
	}
	public function detail($id=NULL)
	{
		$data=$this->Payment->find("first",array("conditions"=>array("Payment.id"=>$id)));
		$this->set("data",$data['Payment']);
	}
	public function change_passenger_list($vehicle_type=NULL)
	{
		$this->layout="ajax";
		$get_passenger=$this->get_passenger($vehicle_type);
		$this->set("get_passenger",$get_passenger);
	}
}
