<?php
App::uses('AppController', 'Controller');
class GroupLanguagesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('GroupLanguage','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'GroupLanguage.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->GroupLanguage->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->GroupLanguage->updateAll(array("GroupLanguage.status"=>'0'),array("GroupLanguage.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->GroupLanguage->updateAll(array("GroupLanguage.status"=>'1'),array("GroupLanguage.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->GroupLanguage->updateAll(array("GroupLanguage.show_home"=>'1'),array("GroupLanguage.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->GroupLanguage->updateAll(array("GroupLanguage.show_home"=>'0'),array("GroupLanguage.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->GroupLanguage->deleteAll(array('GroupLanguage.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['GroupLanguage']['title']) && $this->data['GroupLanguage']['title']!='') $title = $this->data['GroupLanguage']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['GroupLanguage']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['GroupLanguage.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('GroupLanguage.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('group_languages', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add GroupLanguage'));
		if ($this->request->is('post')) {
			$this->GroupLanguage->create();	
			$pre_title_check = $this->GroupLanguage->find("count",array("conditions"=>array("GroupLanguage.title"=>$this->request->data['GroupLanguage']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['GroupLanguage']['date_time']			=	date("Y-m-d H:i:s");
				$languages_id=implode(",",$this->request->data['GroupLanguage']['languages_id']);
				unset($this->request->data['GroupLanguage']['languages_id']);
				$this->request->data['GroupLanguage']['languages_id']=$languages_id;
				if ($res=$this->GroupLanguage->save($this->request->data['GroupLanguage'])){
					$this->Session->setFlash(__('Group Language has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Group Language could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Group Language title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit GroupLanguage'));
		$this->GroupLanguage->id = $id;
		$selected = "";
		
		$driver_detail = $this->GroupLanguage->find("first",array("conditions"=>array("GroupLanguage.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->GroupLanguage->exists()) {
			throw new NotFoundException(__('Invalid group_language'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['GroupLanguage']['id']=$id;	
			$languages_id=implode(",",$this->request->data['GroupLanguage']['languages_id']);
			unset($this->request->data['GroupLanguage']['languages_id']);
			$this->request->data['GroupLanguage']['languages_id']=$languages_id;	
			$pre_title_check = $this->GroupLanguage->find("count",array("conditions"=>array("GroupLanguage.title"=>$this->request->data['GroupLanguage']['title'],"GroupLanguage.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->GroupLanguage->saveAll($this->request->data['GroupLanguage'])) {
					$this->Session->setFlash(__('Group Language has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Group Language could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Group Language title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->GroupLanguage->read(null, $id);
			$this->redirect(array('action' => 'index'));
		}
		$data= $this->GroupLanguage->read(null, $id);
		$languages_id_arr=explode(",",$data['GroupLanguage']['languages_id']);
		unset($data['GroupLanguage']['languages_id']);
		$data['GroupLanguage']['languages_id']=$languages_id_arr;
		$this->request->data = $data;
		
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->GroupLanguage->id = $id;
		if (!$this->GroupLanguage->exists()) {
			throw new NotFoundException(__('Invalid Group Language'));
		}
		else
		{
			if ($this->GroupLanguage->delete()) {
				$this->Session->setFlash(__('Group Language has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Group Language could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
