<?php
App::uses('AppController', 'Controller');
class GamblingSitesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('GamblingSite','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'GamblingSite.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->GamblingSite->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->GamblingSite->updateAll(array("GamblingSite.status"=>'0'),array("GamblingSite.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->GamblingSite->updateAll(array("GamblingSite.status"=>'1'),array("GamblingSite.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->GamblingSite->updateAll(array("GamblingSite.show_home"=>'1'),array("GamblingSite.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->GamblingSite->updateAll(array("GamblingSite.show_home"=>'0'),array("GamblingSite.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->GamblingSite->deleteAll(array('GamblingSite.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['GamblingSite']['title']) && $this->data['GamblingSite']['title']!='') $title = $this->data['GamblingSite']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['GamblingSite']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['GamblingSite.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('GamblingSite.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('gambling_sites', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add GamblingSite'));
		if ($this->request->is('post')) {
			$this->GamblingSite->create();	
			$pre_title_check = $this->GamblingSite->find("count",array("conditions"=>array("GamblingSite.title"=>$this->request->data['GamblingSite']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['GamblingSite']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->GamblingSite->save($this->request->data['GamblingSite'])){
					$this->Session->setFlash(__('Gambling Site has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Gambling Site could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Gambling Site title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit GamblingSite'));
		$this->GamblingSite->id = $id;
		$selected = "";
		
		$driver_detail = $this->GamblingSite->find("first",array("conditions"=>array("GamblingSite.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->GamblingSite->exists()) {
			throw new NotFoundException(__('Invalid gambling_site'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['GamblingSite']['id']=$id;		
			$pre_title_check = $this->GamblingSite->find("count",array("conditions"=>array("GamblingSite.title"=>$this->request->data['GamblingSite']['title'],"GamblingSite.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->GamblingSite->saveAll($this->request->data['GamblingSite'])) {
					$this->Session->setFlash(__('Gambling Site has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Gambling Site could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Gambling Site title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->GamblingSite->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->GamblingSite->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->GamblingSite->id = $id;
		if (!$this->GamblingSite->exists()) {
			throw new NotFoundException(__('Invalid Gambling Site'));
		}
		else
		{
			if ($this->GamblingSite->delete()) {
				$this->Session->setFlash(__('Gambling Site has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Gambling Site could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
