<?php
App::uses('AppController', 'Controller');
class DealNextActionsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('DealNextAction','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'DealNextAction.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkLogin();
		$this->set('title_for_layout', __('Admin'));
		$this->DealNextAction->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->DealNextAction->updateAll(array("DealNextAction.status"=>'0'),array("DealNextAction.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->DealNextAction->updateAll(array("DealNextAction.status"=>'1'),array("DealNextAction.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->DealNextAction->updateAll(array("DealNextAction.show_home"=>'1'),array("DealNextAction.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->DealNextAction->updateAll(array("DealNextAction.show_home"=>'0'),array("DealNextAction.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->DealNextAction->deleteAll(array('DealNextAction.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['DealNextAction']['title']) && $this->data['DealNextAction']['title']!='') $title = $this->data['DealNextAction']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['DealNextAction']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['DealNextAction.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('DealNextAction.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('deal_next_actions', $rows);
	}
	public function admin_add() {
		$this->checkLogin();
		$this->set('title_for_layout', __('Add DealNextAction'));
		if ($this->request->is('post')) {
			$this->DealNextAction->create();	
			$pre_title_check = $this->DealNextAction->find("count",array("conditions"=>array("DealNextAction.title"=>$this->request->data['DealNextAction']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['DealNextAction']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->DealNextAction->save($this->request->data['DealNextAction'])){
					$this->Session->setFlash(__('Deal Next Actions has been added successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Deal Next Actions could not be added.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Deal Next Actions title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkLogin();
		$this->set('title_for_layout', __('Edit DealNextAction'));
		$this->DealNextAction->id = $id;
		$selected = "";
		
		$driver_detail = $this->DealNextAction->find("first",array("conditions"=>array("DealNextAction.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->DealNextAction->exists()) {
			throw new NotFoundException(__('Invalid deal_next_action'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['DealNextAction']['id']=$id;		
			$pre_title_check = $this->DealNextAction->find("count",array("conditions"=>array("DealNextAction.title"=>$this->request->data['DealNextAction']['title'],"DealNextAction.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->DealNextAction->saveAll($this->request->data['DealNextAction'])) {
					$this->Session->setFlash(__('Deal Next Actions has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Deal Next Actions could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Deal Next Actions title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->DealNextAction->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->DealNextAction->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->DealNextAction->id = $id;
		if (!$this->DealNextAction->exists()) {
			throw new NotFoundException(__('Invalid Deal Next Actions'));
		}
		else
		{
			if ($this->DealNextAction->delete()) {
				$this->Session->setFlash(__('Deal Next Actions has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Deal Next Actions could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
