<?php
App::uses('AppController', 'Controller');
class DealInputsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('DealInput','Deal','EmailTemplate','ApplicationSetting','DealFile','Site','Operator'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'DealInput.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_search() {
		
		$this->checkLogin();
		$this->set('title_for_layout', __('Admin'));
		$this->DealInput->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='Delete')
				$this->DealInput->deleteAll(array('DealInput.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['Deal']['deal_status_id']) && $this->data['Deal']['deal_status_id']!='') $deal_status_id = $this->data['Deal']['deal_status_id'];	
		else if(isset($this->params['named']['deal_status_id']) && $this->params['named']['deal_status_id']!='') $deal_status_id = $this->request->data['Deal']['deal_status_id']=$this->params['named']['deal_status_id'];
		
		if(isset($this->data['Deal']['deal_payment_id']) && $this->data['Deal']['deal_payment_id']!='') $deal_payment_id = $this->data['Deal']['deal_payment_id'];	
		else if(isset($this->params['named']['deal_payment_id']) && $this->params['named']['deal_payment_id']!='') $deal_payment_id = $this->request->data['Deal']['deal_payment_id']=$this->params['named']['deal_payment_id'];
		
		if(isset($this->data['Deal']['link_status_id']) && $this->data['Deal']['link_status_id']!='') $link_status_id = $this->data['Deal']['link_status_id'];	
		else if(isset($this->params['named']['link_status_id']) && $this->params['named']['link_status_id']!='') $link_status_id = $this->request->data['Deal']['link_status_id']=$this->params['named']['link_status_id'];
		
		if(isset($this->data['Deal']['live_article_start_date']) && $this->data['Deal']['live_article_start_date']!='') $live_article_start_date = $this->data['Deal']['live_article_start_date'];	
		else if(isset($this->params['named']['live_article_start_date']) && $this->params['named']['live_article_start_date']!='') $live_article_start_date = $this->request->data['Deal']['live_article_start_date']=$this->params['named']['live_article_start_date'];
		
		if(isset($this->data['Deal']['provider_payment_status_id']) && $this->data['Deal']['provider_payment_status_id']!='') $provider_payment_status_id = $this->data['Deal']['provider_payment_status_id'];	
		else if(isset($this->params['named']['provider_payment_status_id']) && $this->params['named']['provider_payment_status_id']!='') $provider_payment_status_id = $this->request->data['Deal']['provider_payment_status_id']=$this->params['named']['provider_payment_status_id'];
		
		if(isset($this->data['Deal']['source_email_id']) && $this->data['Deal']['source_email_id']!='') $source_email_id = $this->data['Deal']['source_email_id'];	
		else if(isset($this->params['named']['source_email_id']) && $this->params['named']['source_email_id']!='') $source_email_id = $this->request->data['Deal']['source_email_id']=$this->params['named']['source_email_id'];
		
		if(isset($this->data['Deal']['site']) && $this->data['Deal']['site']!='') $site = $this->data['Deal']['site'];	
		else if(isset($this->params['named']['site']) && $this->params['named']['site']!='') $site = $this->request->data['Deal']['site']=$this->params['named']['site'];
		
		$conditions = array(); 
		$conditions_deal = array(); 
		$pagingArgs = array(); 
		
		if(!empty($deal_status_id))
		{
			$conditions_deal['Deal.deal_status_id'] = $deal_status_id;
			$pagingArgs['deal_status_id'] = $deal_status_id;
		}
		if(!empty($deal_payment_id))
		{
			$conditions_deal['Deal.deal_payment_id'] = $deal_payment_id;
			$pagingArgs['deal_payment_id'] = $deal_payment_id;
		}
		$deal_id=array();
		if(!empty($conditions_deal))
		{
			$deal_id=array();
			$deal_details=$this->Deal->find("all",array("conditions"=>$conditions_deal,'fields'=>array("Deal.id")));
			foreach($deal_details as $deal_detail)
			{
				$deal_id[]=$deal_detail['Deal']['id'];
			}
			if(count($deal_id)==1)
				$conditions['DealInput.deal_id'] = $deal_id[0];
			else
				$conditions['DealInput.deal_id'] = $deal_id;
		}
		if(!empty($live_article_start_date))
		{
			$conditions['DealInput.live_article_start_date'] = $live_article_start_date;
			$pagingArgs['live_article_start_date'] = $live_article_start_date;
		}	
		if(!empty($link_status_id))
		{
			$conditions['DealInput.link_status_id'] = $link_status_id;
			$pagingArgs['link_status_id'] = $link_status_id;
		}
		if(!empty($source_email_id))
		{
			$conditions['DealInput.source_email_id'] = $source_email_id;
			$pagingArgs['source_email_id'] = $source_email_id;
		}
		if(!empty($site))
		{
			$conditions['DealInput.site like '] = '%'.$site.'%';
			$pagingArgs['site'] = $site;
		}	
		if(!empty($provider_payment_status_id))
		{
			$conditions['DealInput.provider_payment_status_id'] = $provider_payment_status_id;
			$pagingArgs['provider_payment_status_id'] = $provider_payment_status_id;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('DealInput.id'=>'DESC'),
			  'fields'=>array("DealInput.site","DealInput.id","DealInput.deal_id","Deal.temp_deal_name","DealInput.anchor","DealInput.provider_payment_status_id","DealInput.source_email_id","DealInput.live_article_url","Deal.deal_name","Deal.client_id","Deal.client_id"),
			  'conditions'=>$conditions,
			  'joins' => array(
						array(
							'alias' => 'Deal',
							'table' => 'deals',
							'type' => 'INNER',
							'conditions' => '`DealInput`.`deal_id` = `Deal`.`id`'
						)
					),
		 );
		$rows =  $this->paginate();
		$this->set('deals', $rows);
		$operator_detail=$this->Operator->find("first",array("conditions"=>array("Operator.user_id"=>$this->Auth->user('id'))));
		$this->set('operator_detail', $operator_detail['Operator']);
	}
}
