<?php
App::uses('AppController', 'Controller');
class ClientSiteUrlsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('ClientSiteUrl','EmailTemplate','ApplicationSetting','TempClientSiteUrl','Site','ClientSiteRecord');
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'ClientSiteUrl.id' => 'desc'
        )
    );
	public function beforeFilter() {
        parent::beforeFilter();
	}	
	public function admin_index($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->ClientSiteUrl->recursive = 0;
		$limit=$this->get_application_setting('result_limit');
		
		
		if ($this->request->is('post') || $this->request->is('put')) {
			if($this->request->data['task_value']=='Delete')
				$this->ClientSiteUrl->deleteAll(array('ClientSiteUrl.id' => $this->request->data['frmList']['ID']), false);
		}
		if(isset($this->data['ClientSiteUrl']['client_id']) && $this->data['ClientSiteUrl']['client_id']!='') $client_id = $this->data['ClientSiteUrl']['client_id'];	
		else if(isset($this->params['named']['client_id']) && $this->params['named']['client_id']!='') $client_id = $this->request->data['ClientSiteUrl']['client_id']=$this->params['named']['client_id'];
		
		if(isset($this->data['ClientSiteUrl']['url']) && $this->data['ClientSiteUrl']['url']!='') $url = $this->data['ClientSiteUrl']['url'];	
		else if(isset($this->params['named']['url']) && $this->params['named']['url']!='') $url = $this->request->data['ClientSiteUrl']['url']=$this->params['named']['url'];
		if(isset($this->data['ClientSiteUrl']['limit']) && $this->data['ClientSiteUrl']['limit']!='') $limit = $this->data['ClientSiteUrl']['limit'];	
		else if(isset($this->params['named']['limit']) && $this->params['named']['limit']!='') $limit = $this->request->data['ClientSiteUrl']['limit']=$this->params['named']['limit'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		//echo '<pre>';print_r($this->data['ClientSiteUrl']);
		
		if(!empty($client_id))
		{
			$conditions['ClientSiteUrl.client_id'] = $client_id;
			$pagingArgs['client_id'] = $client_id;
		}
		if(!empty($url))
		{
			$res=$this->Site->find("first",array("conditions"=>array("Site.url LIKE "=>'%'.$url.'%')));
			
			$conditions['ClientSiteUrl.site_id'] = $res['Site']['id'];
			$pagingArgs['url'] = $url;
		}
		if(!empty($limit))
		{
			$pagingArgs['limit'] = $limit;
		}
		$this->set("pagingArgs",$pagingArgs);	
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('ClientSiteUrl.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('client_sites', $rows);
		if(isset($this->request->params['named']['page']) && $this->request->params['named']['page'])
			$page_no=($this->request->params['named']['page']-1)*$limit;
		else
			$page_no=0;
		$this->set("page_no",$page_no);
		
		$this->params['page_title'] = "ClientSiteUrl";
		if($id != null){
		$this->ClientSiteUrl->id = $id;
		if (!$this->ClientSiteUrl->exists()) {
			throw new NotFoundException(__('Invalid ClientSiteUrl'));
		}
		}
	}
	public function admin_import()
	{
		if ($this->request->is('post') || $this->request->is('put')) {
			if (($handle = fopen($this->request->data['ClientSiteUrl']['import_cvs']['tmp_name'], "r")) !== FALSE) {
			  $count=1;
			  while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
						$val=trim($data[0]);
						if($val=='url')
							continue;
						$check_id=$this->Site->find("first",array("conditions"=>array("Site.url like "=>'%'.$val.'%')));
						$site_id=$check_id['Site']['id'];
						$count=$this->ClientSiteUrl->find("count",array("conditions"=>array("ClientSiteUrl.site_id"=>$site_id,"ClientSiteUrl.client_id"=>$this->data['ClientSiteUrl']['client_id'])));
						if($count==0 && !empty($site_id))
						{
							$arr=array();
							$arr['id']='';
							$arr['site_id']=$site_id;
							$arr['client_id']=$this->data['ClientSiteUrl']['client_id'];
							$arr['date_time']=date("Y-m-d H:i:s");
							$this->ClientSiteUrl->save($arr);
						}
					}
				}
			$this->Session->setFlash(__('Client Site url has been added successfully.'), 'default', array('class' => 'success'));
			$this->redirect(array('action' => 'index'));
		}
	}
	public function admin_export()
	{
		Configure::write('debug',2);
		$this->autoRender = false;
		$this->Site->recursive = 0;
		
		if(isset($this->data['download']['search_client_id']) && $this->data['download']['search_client_id']!='') $search_client_id = $this->data['download']['search_client_id'];	
		else if(isset($this->params['named']['search_client_id']) && $this->params['named']['search_client_id']!='') $search_client_id = $this->request->data['ClientSiteUrl']['search_client_id']=$this->params['named']['search_client_id'];
		
		if(isset($this->data['download']['search_url']) && $this->data['download']['search_url']!='') $search_url = $this->data['download']['search_url'];	
		else if(isset($this->params['named']['search_url']) && $this->params['named']['search_url']!='') $search_url =$this->request->data['ClientSiteUrl']['search_url']=$this->params['named']['search_url'];
		
		if(isset($this->data['download']['limit']) && $this->data['download']['limit']!='') $limit = $this->data['download']['limit'];	
		else if(isset($this->params['named']['limit']) && $this->params['named']['limit']!='') $limit = $this->request->data['ClientSiteUrl']['limit']=$this->params['named']['limit'];
		
		//echo '<pre>';print_r($this->data['download']);
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($search_client_id))
		{
			$conditions['ClientSiteUrl.client_id'] = $search_client_id;
			$pagingArgs['search_client_id'] = $search_client_id;
		}
		if(!empty($search_url))
		{
			$res=$this->Site->find("first",array("conditions"=>array("Site.url LIKE "=>'%'.$search_url.'%')));
			
			$conditions['ClientSiteUrl.site_id'] = $res['Site']['id'];
			$pagingArgs['search_url'] = $search_url;
		}
		$rows = $this->ClientSiteUrl->find("all",array('order'=>array('ClientSiteUrl.id'=>'DESC'),'conditions'=>$conditions));
		
		$namedate=__("Client-Site-Url")."-".date("m.d.y");
		$file_type = "vnd.ms-excel";
		$file_ending = "csv";
		header("Content-Type: application/$file_type");
		header("Content-Disposition: attachment; filename=$namedate.$file_ending");
		header("Pragma: no-cache");
		header("Expires: 0");
		$title = __("Report");
		$sep = ", ";
		$array_key=array(__("Client"),__("URL"));
		//start of printing column names as names of MySQL fields
		for ($i = 0; $i < count($array_key); $i++)
		{
			echo $array_key[$i] . ", ";
		}
		print("\n");
		foreach($rows as $site)
		{
			$client=$this->get_client($site['ClientSiteUrl']['client_id']);
			$site_data=$this->get_site($site['ClientSiteUrl']['site_id']);
			$url=$site_data['url'];
			
			$schema_insert = "";
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$client)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$url)).$sep;
			$schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
			$schema_insert .= "\t";
			print(trim($schema_insert));
			print "\n";
		}
		exit;		
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->ClientSiteUrl->id = $id;
		if (!$this->ClientSiteUrl->exists()) {
			throw new NotFoundException(__('Invalid Client Site Url'));
		}
		else
		{
			if ($this->ClientSiteUrl->delete()) {
				$this->Session->setFlash(__('Client Site Url has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Client Site Url could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
