<?php
App::uses('AppController', 'Controller');
class ArticleDurationsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('ArticleDuration','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'ArticleDuration.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->ArticleDuration->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->ArticleDuration->updateAll(array("ArticleDuration.status"=>'0'),array("ArticleDuration.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->ArticleDuration->updateAll(array("ArticleDuration.status"=>'1'),array("ArticleDuration.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->ArticleDuration->updateAll(array("ArticleDuration.show_home"=>'1'),array("ArticleDuration.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->ArticleDuration->updateAll(array("ArticleDuration.show_home"=>'0'),array("ArticleDuration.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->ArticleDuration->deleteAll(array('ArticleDuration.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['ArticleDuration']['title']) && $this->data['ArticleDuration']['title']!='') $title = $this->data['ArticleDuration']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['ArticleDuration']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['ArticleDuration.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('ArticleDuration.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('article_durations', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add ArticleDuration'));
		if ($this->request->is('post')) {
			$this->ArticleDuration->create();	
			$pre_title_check = $this->ArticleDuration->find("count",array("conditions"=>array("ArticleDuration.title"=>$this->request->data['ArticleDuration']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['ArticleDuration']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->ArticleDuration->save($this->request->data['ArticleDuration'])){
					$this->Session->setFlash(__('Article Duration has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Article Duration could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Article Duration title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit ArticleDuration'));
		$this->ArticleDuration->id = $id;
		$selected = "";
		
		$driver_detail = $this->ArticleDuration->find("first",array("conditions"=>array("ArticleDuration.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->ArticleDuration->exists()) {
			throw new NotFoundException(__('Invalid article_duration'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['ArticleDuration']['id']=$id;		
			$pre_title_check = $this->ArticleDuration->find("count",array("conditions"=>array("ArticleDuration.title"=>$this->request->data['ArticleDuration']['title'],"ArticleDuration.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->ArticleDuration->saveAll($this->request->data['ArticleDuration'])) {
					$this->Session->setFlash(__('Article Duration has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Article Duration could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Article Duration title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->ArticleDuration->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->ArticleDuration->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->ArticleDuration->id = $id;
		if (!$this->ArticleDuration->exists()) {
			throw new NotFoundException(__('Invalid Article Duration'));
		}
		else
		{
			if ($this->ArticleDuration->delete()) {
				$this->Session->setFlash(__('Article Duration has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Article Duration could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
