<?php
App::uses('AppController', 'Controller');
class StatusEmployeesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('StatusEmployee','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'StatusEmployee.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->StatusEmployee->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->StatusEmployee->updateAll(array("StatusEmployee.status"=>'0'),array("StatusEmployee.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->StatusEmployee->updateAll(array("StatusEmployee.status"=>'1'),array("StatusEmployee.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->StatusEmployee->updateAll(array("StatusEmployee.show_home"=>'1'),array("StatusEmployee.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->StatusEmployee->updateAll(array("StatusEmployee.show_home"=>'0'),array("StatusEmployee.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->StatusEmployee->deleteAll(array('StatusEmployee.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['StatusEmployee']['title']) && $this->data['StatusEmployee']['title']!='') $title = $this->data['StatusEmployee']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['StatusEmployee']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['StatusEmployee.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('StatusEmployee.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('status_employees', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add StatusEmployee'));
		if ($this->request->is('post')) {
			$this->StatusEmployee->create();	
			$pre_title_check = $this->StatusEmployee->find("count",array("conditions"=>array("StatusEmployee.title"=>$this->request->data['StatusEmployee']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['StatusEmployee']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->StatusEmployee->save($this->request->data['StatusEmployee'])){
					$this->Session->setFlash(__('Status has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Status could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Status title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit StatusEmployee'));
		$this->StatusEmployee->id = $id;
		$selected = "";
		
		$driver_detail = $this->StatusEmployee->find("first",array("conditions"=>array("StatusEmployee.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->StatusEmployee->exists()) {
			throw new NotFoundException(__('Invalid Status'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['StatusEmployee']['id']=$id;		
			$pre_title_check = $this->StatusEmployee->find("count",array("conditions"=>array("StatusEmployee.title"=>$this->request->data['StatusEmployee']['title'],"StatusEmployee.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->StatusEmployee->saveAll($this->request->data['StatusEmployee'])) {
					$this->Session->setFlash(__('Status has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Status could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Status title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->StatusEmployee->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->StatusEmployee->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->StatusEmployee->id = $id;
		if (!$this->StatusEmployee->exists()) {
			throw new NotFoundException(__('Invalid Error'));
		}
		else
		{
			if ($this->StatusEmployee->delete()) {
				$this->Session->setFlash(__('Status has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Status could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
