<?php
App::uses('AppController', 'Controller');
class SitesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('Site','EmailTemplate','ApplicationSetting','TempSite'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'Site.id' => 'desc'
        )
    );
	public function beforeFilter() {
        parent::beforeFilter();
	}	
	public function admin_index($id = null) {
		$this->checkSubAdminChecker();
		$this->set('title_for_layout', __('Admin'));
		$this->Site->recursive = 0;
		if ($this->request->is('post') || $this->request->is('put')) {
			if($this->Session->read('Auth.User.role')=='1')
			{
				if($this->request->data['task_value']=='DeActive')
					$this->Site->updateAll(array("Site.status"=>'0'),array("Site.id"=>$this->request->data['frmList']['ID']));
				else if($this->request->data['task_value']=='Active')
				{
					$this->Site->updateAll(array("Site.status"=>'1'),array("Site.id"=>$this->request->data['frmList']['ID']));
					foreach($this->request->data['frmList']['ID'] as $userid)
					{
						$this->add_site_data($userid);
					}
				}
				else if($this->request->data['task_value']=='Delete')
				{
					$this->Site->deleteAll(array('Site.id' => $this->request->data['frmList']['ID']), false);
				}
			}
		}
		$limit=$this->get_application_setting('result_limit');
		if(isset($this->data['Site']['user_id']) && $this->data['Site']['user_id']!='') $user_id = $this->data['Site']['user_id'];	
		else if(isset($this->params['named']['user_id']) && $this->params['named']['user_id']!='') $user_id = $this->request->data['Site']['user_id']=$this->params['named']['user_id'];
		
		if(isset($this->data['Site']['url']) && $this->data['Site']['url']!='') $url = $this->data['Site']['url'];	
		else if(isset($this->params['named']['url']) && $this->params['named']['url']!='') $url = $this->request->data['Site']['url']=$this->params['named']['url'];
		
		if(isset($this->data['Site']['article_price_from']) && $this->data['Site']['article_price_from']!='') $article_price_from = $this->data['Site']['article_price_from'];	
		else if(isset($this->params['named']['article_price_from']) && $this->params['named']['article_price_from']!='') $article_price_from =$this->request->data['Site']['article_price_from']=$this->params['named']['article_price_from'];
		
		if(isset($this->data['Site']['article_price_to']) && $this->data['Site']['article_price_to']!='') $article_price_to = $this->data['Site']['article_price_to'];	
		else if(isset($this->params['named']['article_price_to']) && $this->params['named']['article_price_to']!='') $article_price_to = $this->request->data['Site']['article_price_to']=$this->params['named']['article_price_to'];
		
		if(isset($this->data['Site']['article_duration_id']) && $this->data['Site']['article_duration_id']!='') $article_duration_id = $this->data['Site']['article_duration_id'];	
		else if(isset($this->params['named']['article_duration_id']) && $this->params['named']['article_duration_id']!='') $article_duration_id = $this->request->data['Site']['article_duration_id']=$this->params['named']['article_duration_id'];
		
		if(isset($this->data['Site']['home_page_link_price_from']) && $this->data['Site']['home_page_link_price_from']!='') $home_page_link_price_from = $this->data['Site']['home_page_link_price_from'];	
		else if(isset($this->params['named']['home_page_link_price_from']) && $this->params['named']['home_page_link_price_from']!='') $home_page_link_price_from = $this->request->data['Site']['home_page_link_price_from']=$this->params['named']['home_page_link_price_from'];
		
		if(isset($this->data['Site']['home_page_link_price_to']) && $this->data['Site']['home_page_link_price_to']!='') $home_page_link_price_to = $this->data['Site']['home_page_link_price_to'];	
		else if(isset($this->params['named']['home_page_link_price_to']) && $this->params['named']['home_page_link_price_to']!='') $home_page_link_price_to = $this->request->data['Site']['home_page_link_price_to']=$this->params['named']['home_page_link_price_to'];
		if(isset($this->data['Site']['language_id']) && $this->data['Site']['language_id']!='') $language_id = $this->data['Site']['language_id'];	
		else if(isset($this->params['named']['language_id']) && $this->params['named']['language_id']!='') $language_id = $this->request->data['Site']['language_id']=$this->params['named']['language_id'];
		
		if(isset($this->data['Site']['tf_id']) && $this->data['Site']['tf_id']!='') $tf_id = $this->data['Site']['tf_id'];	
		else if(isset($this->params['named']['tf_id']) && $this->params['named']['tf_id']!='') $tf_id = $this->request->data['Site']['tf_id']=$this->params['named']['tf_id'];
		
		if(isset($this->data['Site']['cf_id']) && $this->data['Site']['cf_id']!='') $cf_id = $this->data['Site']['cf_id'];	
		else if(isset($this->params['named']['cf_id']) && $this->params['named']['cf_id']!='') $cf_id = $this->request->data['Site']['cf_id']=$this->params['named']['cf_id'];
		
		if(isset($this->data['Site']['da_id']) && $this->data['Site']['da_id']!='') $da_id = $this->data['Site']['da_id'];	
		else if(isset($this->params['named']['da_id']) && $this->params['named']['da_id']!='') $da_id = $this->request->data['Site']['da_id']=$this->params['named']['da_id'];
		
		if(isset($this->data['Site']['provider_contact']) && $this->data['Site']['provider_contact']!='') $provider_contact = $this->data['Site']['provider_contact'];	
		else if(isset($this->params['named']['provider_contact']) && $this->params['named']['provider_contact']!='') $provider_contact = $this->request->data['Site']['provider_contact']=$this->params['named']['provider_contact'];
		
		if(isset($this->data['Site']['availability_id']) && $this->data['Site']['availability_id']!='') $availability_id = $this->data['Site']['availability_id'];	
		else if(isset($this->params['named']['availability_id']) && $this->params['named']['availability_id']!='') $availability_id = $this->request->data['Site']['availability_id']=$this->params['named']['availability_id'];
		
		if(isset($this->data['Site']['theme_site_id']) && $this->data['Site']['theme_site_id']!='') $theme_site_id = $this->data['Site']['theme_site_id'];	
		else if(isset($this->params['named']['theme_site_id']) && $this->params['named']['theme_site_id']!='') $theme_site_id = $this->request->data['Site']['theme_site_id']=$this->params['named']['theme_site_id'];
		
		if(isset($this->data['Site']['gambling_site_id']) && $this->data['Site']['gambling_site_id']!='') $gambling_site_id = $this->data['Site']['gambling_site_id'];	
		else if(isset($this->params['named']['gambling_site_id']) && $this->params['named']['gambling_site_id']!='') $gambling_site_id = $this->request->data['Site']['gambling_site_id']=$this->params['named']['gambling_site_id'];
		
		if(isset($this->data['Site']['accept_gambling_id']) && $this->data['Site']['accept_gambling_id']!='') $accept_gambling_id = $this->data['Site']['accept_gambling_id'];	
		else if(isset($this->params['named']['accept_gambling_id']) && $this->params['named']['accept_gambling_id']!='') $accept_gambling_id = $this->request->data['Site']['accept_gambling_id']=$this->params['named']['accept_gambling_id'];
		
		if(isset($this->data['Site']['accept_sport_betting_id']) && $this->data['Site']['accept_sport_betting_id']!='') $accept_sport_betting_id = $this->data['Site']['accept_sport_betting_id'];	
		else if(isset($this->params['named']['accept_sport_betting_id']) && $this->params['named']['accept_sport_betting_id']!='') $accept_sport_betting_id = $this->request->data['Site']['accept_sport_betting_id']=$this->params['named']['accept_sport_betting_id'];
		
		if(isset($this->data['Site']['date_time_from']) && $this->data['Site']['date_time_from']!='') $date_time_from = $this->data['Site']['date_time_from'];	
		else if(isset($this->params['named']['date_time_from']) && $this->params['named']['date_time_from']!='') $date_time_from = $this->request->data['Site']['date_time_from']=$this->params['named']['date_time_from'];
				
		if(isset($this->data['Site']['date_time_to']) && $this->data['Site']['date_time_to']!='') $date_time_to = $this->data['Site']['date_time_to'];	
		else if(isset($this->params['named']['date_time_to']) && $this->params['named']['date_time_to']!='') $date_time_to = $this->request->data['Site']['date_time_to']=$this->params['named']['date_time_to'];
		
		if(isset($this->data['Site']['original_email_id']) && $this->data['Site']['original_email_id']!='') $original_email_id = $this->data['Site']['original_email_id'];	
		else if(isset($this->params['named']['original_email_id']) && $this->params['named']['original_email_id']!='') $original_email_id = $this->request->data['Site']['original_email_id']=$this->params['named']['original_email_id'];
		
		if(isset($this->data['Site']['employee_id']) && $this->data['Site']['employee_id']!='') $employee_id = $this->data['Site']['employee_id'];	
		else if(isset($this->params['named']['employee_id']) && $this->params['named']['employee_id']!='') $employee_id = $this->request->data['Site']['employee_id']=$this->params['named']['employee_id'];		
		
		if(isset($this->data['Site']['target_market_id']) && $this->data['Site']['target_market_id']!='') $target_market_id = $this->data['Site']['target_market_id'];	
		else if(isset($this->params['named']['target_market_id']) && $this->params['named']['target_market_id']!='') $target_market_id = $this->request->data['Site']['target_market_id']=$this->params['named']['target_market_id'];
		
		if(isset($this->data['Site']['url_id']) && $this->data['Site']['url_id']!='') $url_id = $this->data['Site']['url_id'];	
		else if(isset($this->params['named']['url_id']) && $this->params['named']['url_id']!='') $url_id = $this->request->data['Site']['url_id']=$this->params['named']['url_id'];
		
		if(isset($this->data['Site']['waiting_approval']) && $this->data['Site']['waiting_approval']!='') $waiting_approval = $this->data['Site']['waiting_approval'];	
		else if(isset($this->params['named']['waiting_approval']) && $this->params['named']['waiting_approval']!='') $waiting_approval = $this->request->data['Site']['waiting_approval']=$this->params['named']['waiting_approval'];
		
		if(isset($this->data['Site']['tested_edit_date_from']) && $this->data['Site']['tested_edit_date_from']!='') $tested_edit_date_from = $this->data['Site']['tested_edit_date_from'];	
		else if(isset($this->params['named']['tested_edit_date_from']) && $this->params['named']['tested_edit_date_from']!='') $tested_edit_date_from =$this->request->data['Site']['tested_edit_date_from']=$this->params['named']['tested_edit_date_from'];
		//echo '<pre>';print_r($this->data['Site']);
		if(isset($this->data['Site']['tested_edit_time_from']) && $this->data['Site']['tested_edit_time_from']!='') $tested_edit_time_from = $this->data['Site']['tested_edit_time_from'];	
		else if(isset($this->params['named']['tested_edit_time_from']) && $this->params['named']['tested_edit_time_from']!='') $tested_edit_time_from =$this->request->data['Site']['tested_edit_time_from']=$this->params['named']['tested_edit_time_from'];
		
		if(isset($this->data['Site']['tested_edit_date_to']) && $this->data['Site']['tested_edit_date_to']!='') $tested_edit_date_to = $this->request->data['Site']['tested_edit_date_to'];	
		else if(isset($this->params['named']['tested_edit_date_to']) && $this->params['named']['tested_edit_date_to']!='') $tested_edit_date_to = $this->request->data['Site']['tested_edit_date_to']=$this->params['named']['tested_edit_date_to'];
		
		if(isset($this->data['Site']['tested_edit_time_to']) && $this->data['Site']['tested_edit_time_to']!='') $tested_edit_time_to = $this->request->data['Site']['tested_edit_time_to'];	
		else if(isset($this->params['named']['tested_edit_time_to']) && $this->params['named']['tested_edit_time_to']!='') $tested_edit_time_to = $this->request->data['Site']['tested_edit_time_to']=$this->params['named']['tested_edit_time_to'];
		
		if(isset($this->data['Site']['limit']) && $this->data['Site']['limit']!='') $limit = $this->data['Site']['limit'];	
		else if(isset($this->params['named']['limit']) && $this->params['named']['limit']!='') $limit = $this->request->data['Site']['limit']=$this->params['named']['limit'];
		
		$conditions = array(); 
		if($this->Session->read('Auth.User.role')=='4')
			$conditions['Site.tested <> ']=2;
		$pagingArgs = array(); 
		//echo '<pre>';print_r($this->data['Site']);
		//if($this->Session->read('Auth.User.role') !=1)
			//$conditions['Site.user_id']=$this->Auth->user('id');
			
		$date_time_only=2;
		if(!empty($url))
		{
			$date_time_only=1;
			$conditions['Site.url LIKE '] = '%'.$url.'%';
			$pagingArgs['url'] = $url;
		}
		else if($this->Session->read('Auth.User.role') !=1 && $this->Session->read('Auth.User.role') !=4)
		{
			$conditions['Site.url'] = '-2017';
		}
		if(!empty($article_price_from))
		{
			$date_time_only=1;
			$conditions['Site.article_price >='] = $article_price_from;
			$pagingArgs['article_price_from'] = $article_price_from;
		}
		if(!empty($article_price_to))
		{
			$date_time_only=1;
			$conditions['Site.article_price <='] = $article_price_to;
			$pagingArgs['article_price_to'] = $article_price_to;
		}
		if(!empty($article_duration_id))
		{
			$date_time_only=1;
			$conditions['Site.article_duration_id'] = $article_duration_id;
			$pagingArgs['article_duration_id'] = $article_duration_id;
		}
		if(!empty($home_page_link_price_from))
		{
			$date_time_only=1;
			$conditions['Site.home_page_link_price >='] = $home_page_link_price_from;
			$pagingArgs['home_page_link_price_from'] = $home_page_link_price_from;
		}
		if(!empty($home_page_link_price_to))
		{
			$date_time_only=1;
			$conditions['Site.home_page_link_price <='] = $home_page_link_price_to;
			$pagingArgs['home_page_link_price_to'] = $home_page_link_price_to;
		}
		if(!empty($language_id))
		{
			$date_time_only=1;
			$conditions['Site.language_id'] = $language_id;
			$pagingArgs['language_id'] = $language_id;
		}
		if(!empty($tf_id))
		{
			$date_time_only=1;
			$conditions['Site.tf_id >= '] = $tf_id;
			$pagingArgs['tf_id'] = $tf_id;
		}		
		if(!empty($cf_id))
		{
			$date_time_only=1;
			$conditions['Site.cf_id >= '] = $cf_id;
			$pagingArgs['cf_id'] = $cf_id;
		}	
		if(!empty($da_id))
		{
			$date_time_only=1;
			$conditions['Site.da_id >= '] = $da_id;
			$pagingArgs['da_id'] = $da_id;
		}
		if(!empty($provider_contact))
		{
			$date_time_only=1;
			$conditions['Site.provider_contact LIKE '] = '%'.$provider_contact.'%';
			$pagingArgs['provider_contact'] = $provider_contact;
		}
		if(!empty($availability_id))
		{
			$date_time_only=1;
			$conditions['Site.availability_id'] = $availability_id;
			$pagingArgs['availability_id'] = $availability_id;
		}
		if(!empty($theme_site_id))
		{
			$date_time_only=1;
			$conditions['Site.theme_site_id'] = $theme_site_id;
			$pagingArgs['theme_site_id'] = $theme_site_id;
		}
		if(!empty($gambling_site_id))
		{
			$date_time_only=1;
			$conditions['Site.gambling_site_id'] = $gambling_site_id;
			$pagingArgs['gambling_site_id'] = $gambling_site_id;
		}
		if(!empty($accept_gambling_id))
		{
			$date_time_only=1;
			$conditions['Site.accept_gambling_id'] = $accept_gambling_id;
			$pagingArgs['accept_gambling_id'] = $accept_gambling_id;
		}
		if(!empty($accept_sport_betting_id))
		{
			$date_time_only=1;
			$conditions['Site.accept_sport_betting_id'] = $accept_sport_betting_id;
			$pagingArgs['accept_sport_betting_id'] = $accept_sport_betting_id;
		}
		if(!empty($gambling_site_id))
		{
			$date_time_only=1;
			$conditions['Site.gambling_site_id'] = $gambling_site_id;
			$pagingArgs['gambling_site_id'] = $gambling_site_id;
		}
		if(!empty($date_time_from))
		{
			$date_time_only=1;
			$conditions['Site.today_date >= '] = $date_time_from;
			$pagingArgs['date_time_from'] = $date_time_from;
		}
		if(!empty($date_time_to))
		{
			$date_time_only=1;
			$conditions['Site.today_date <= '] = $date_time_to;
			$pagingArgs['date_time_to'] = $date_time_to;
		}
		if(!empty($original_email_id))
		{
			$date_time_only=1;
			$conditions['Site.original_email_id'] = $original_email_id;
			$pagingArgs['original_email_id'] = $original_email_id;
		}
		if(!empty($employee_id))
		{
			$date_time_only=1;
			$conditions['Site.employee_id'] = $employee_id;
			$pagingArgs['employee_id'] = $employee_id;
		}
		if(!empty($target_market_id))
		{
			$date_time_only=1;
			$conditions['Site.target_market_id'] = $target_market_id;
			$pagingArgs['target_market_id'] = $target_market_id;
		}
		if(!empty($tested_edit_date_from))
		{
			$date_employee_from_temp=$tested_edit_date_from.' 00:00:00';
			if(!empty($tested_edit_time_from))
			{
				$tested_edit_time_from_temp=$this->get_employee_time($tested_edit_time_from);
				$date_employee_from_temp=$tested_edit_date_from.' '.$tested_edit_time_from_temp;
				$pagingArgs['tested_edit_time_from'] = $tested_edit_time_from;
			}
			$conditions['Site.tested_edit_date_time >='] = $date_employee_from_temp;
			$pagingArgs['date_employee_from'] = $date_employee_from;
		}
		if(!empty($tested_edit_date_to))
		{
			$date_employee_to_temp=$tested_edit_date_to.' 23:59:59';
			if(!empty($tested_edit_time_to))
			{
				$tested_edit_time_to_temp=$this->get_employee_time($tested_edit_time_to);
				$date_employee_to_temp=$tested_edit_date_to.' '.$tested_edit_time_to_temp;
				$pagingArgs['tested_edit_time_to'] = $tested_edit_time_to;
			}
			$conditions['Site.tested_edit_date_time <='] = $date_employee_to_temp;
			$pagingArgs['date_employee_to'] = $date_employee_to;
		}
		if(!empty($url_id))
		{
			$date_time_only=1;
			$conditions['Site.id <= '] = $url_id;
			$pagingArgs['url_id'] = $url_id;
		}
		if(!empty($user_id))
		{
			$date_time_only=1;
			$conditions['Site.user_id'] = $user_id;
			$pagingArgs['user_id'] = $user_id;
		}
		if(!empty($waiting_approval))
		{
			$check_temp_sites=$this->TempSite->find("all",array("conditions"=>array("TempSite.user_id"=>$this->Auth->user('id')),"fields"=>array("site_id")));
			$site_id_arr=array();
			foreach($check_temp_sites as $check_temp_site)
			{
				$site_id_arr[]=$check_temp_site['TempSite']['site_id'];
			}
			if(!empty($site_id_arr))
			{
				$imp_site_id=implode(',',$site_id_arr);
				$conditions['Site.id'] = $imp_site_id;
			}
			$pagingArgs['waiting_approval'] = $waiting_approval;
		}
		if(!empty($limit))
		{
			$pagingArgs['limit'] = $limit;
		}
		if(empty($conditions))
			$date_time_only=1;
		$orderby=array('Site.id'=>'DESC');
		if($date_time_only=='2')
			$orderby=array('Site.tested_edit_date_time'=>'DESC');
		if($this->Session->read('Auth.User.role')=='4')	
			$orderby=array('Site.id'=>'DESC');
		//echo '<pre>';print_r($orderby);
		$this->set("pagingArgs",$pagingArgs);	
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>$orderby,
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('sites', $rows);
		$this->set('date_time_only', $date_time_only);
		if(isset($this->request->params['named']['page']) && $this->request->params['named']['page'])
			$page_no=($this->request->params['named']['page']-1)*$limit;
		else
			$page_no=0;
		$this->set("page_no",$page_no);
		
		$this->params['page_title'] = "Site";
		if($id != null){
		$this->Site->id = $id;
		if (!$this->Site->exists()) {
			throw new NotFoundException(__('Invalid Site'));
		}
		}
		
	}
	public function admin_checker() {
		$this->checkSubAdminChecker();
		$this->set('title_for_layout', __('Admin'));
		$this->Site->recursive = 0;
		if ($this->request->is('post') || $this->request->is('put')) {
			if($this->Session->read('Auth.User.role')=='1')
			{
				if($this->request->data['task_value']=='DeActive')
					$this->Site->updateAll(array("Site.status"=>'0'),array("Site.id"=>$this->request->data['frmList']['ID']));
				else if($this->request->data['task_value']=='Active')
				{
					$this->Site->updateAll(array("Site.status"=>'1'),array("Site.id"=>$this->request->data['frmList']['ID']));
					foreach($this->request->data['frmList']['ID'] as $userid)
					{
						$this->add_site_data($userid);
					}
				}
				else if($this->request->data['task_value']=='Delete')
				{
					$this->Site->deleteAll(array('Site.id' => $this->request->data['frmList']['ID']), false);
				}
			}
		}
		$limit=$this->get_application_setting('result_limit');
		
		if(isset($this->data['Site']['url']) && $this->data['Site']['url']!='') $url = $this->data['Site']['url'];	
		else if(isset($this->params['named']['url']) && $this->params['named']['url']!='') $url = $this->request->data['Site']['url']=$this->params['named']['url'];
		
		if(isset($this->data['Site']['availability_id']) && $this->data['Site']['availability_id']!='') $availability_id = $this->data['Site']['availability_id'];	
		else if(isset($this->params['named']['availability_id']) && $this->params['named']['availability_id']!='') $availability_id = $this->request->data['Site']['availability_id']=$this->params['named']['availability_id'];
		
		if(isset($this->data['Site']['theme_site_id']) && $this->data['Site']['theme_site_id']!='') $theme_site_id = $this->data['Site']['theme_site_id'];	
		else if(isset($this->params['named']['theme_site_id']) && $this->params['named']['theme_site_id']!='') $theme_site_id = $this->request->data['Site']['theme_site_id']=$this->params['named']['theme_site_id'];
		
		if(isset($this->data['Site']['url_id']) && $this->data['Site']['url_id']!='') $url_id = $this->data['Site']['url_id'];	
		else if(isset($this->params['named']['url_id']) && $this->params['named']['url_id']!='') $url_id = $this->request->data['Site']['url_id']=$this->params['named']['url_id'];
		
		if(isset($this->data['Site']['waiting_approval']) && $this->data['Site']['waiting_approval']!='') $waiting_approval = $this->data['Site']['waiting_approval'];	
		else if(isset($this->params['named']['waiting_approval']) && $this->params['named']['waiting_approval']!='') $waiting_approval = $this->request->data['Site']['waiting_approval']=$this->params['named']['waiting_approval'];
		
		if(isset($this->data['Site']['tested']) && $this->data['Site']['tested']!='') $tested = $this->data['Site']['tested'];	
		else if(isset($this->params['named']['tested']) && $this->params['named']['tested']!='') $tested =$this->request->data['Site']['tested']=$this->params['named']['tested'];
		
		if(isset($this->data['Site']['limit']) && $this->data['Site']['limit']!='') $limit = $this->data['Site']['limit'];	
		else if(isset($this->params['named']['limit']) && $this->params['named']['limit']!='') $limit = $this->request->data['Site']['limit']=$this->params['named']['limit'];
		
		$conditions = array(); 
		$pagingArgs = array(); 

		if(!empty($url))
		{
			$date_time_only=1;
			$conditions['Site.url LIKE '] = '%'.$url.'%';
			$pagingArgs['url'] = $url;
		}
		if(!empty($availability_id))
		{
			$date_time_only=1;
			$conditions['Site.availability_id'] = $availability_id;
			$pagingArgs['availability_id'] = $availability_id;
		}
		if(!empty($theme_site_id))
		{
			$date_time_only=1;
			$conditions['Site.theme_site_id'] = $theme_site_id;
			$pagingArgs['theme_site_id'] = $theme_site_id;
		}
		if(!empty($tested))
		{
			$conditions['Site.tested <= '] = $tested;
			$pagingArgs['tested'] = $tested;
		}
		if(!empty($url_id))
		{
			$conditions['Site.id <= '] = $url_id;
			$pagingArgs['url_id'] = $url_id;
		}
		if(!empty($limit))
		{
			$pagingArgs['limit'] = $limit;
		}
			
		$orderby=array('Site.id'=>'DESC');
		//echo '<pre>';print_r($orderby);
		$this->set("pagingArgs",$pagingArgs);	
		$this->paginate = array(
			  'limit'=>200,
			  'maxLimit' => 100000,
			  'order'=>$orderby,
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('sites', $rows);
		if(isset($this->request->params['named']['page']) && $this->request->params['named']['page'])
			$page_no=($this->request->params['named']['page']-1)*$limit;
		else
			$page_no=0;
		$this->set("page_no",$page_no);
		
		$this->params['page_title'] = "Site";
		
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$user_id = $this->Auth->user('id');	
		$this->set('title_for_layout', __('Add Site'));
		if ($this->request->is('post')) {
			$this->Site->create();
			if($this->Session->read('Auth.User.role') !=1)
				$this->request->data['Site']['user_id']=$this->Auth->user('id');	
			$this->request->data['Site']['date_time']			=	date("Y-m-d H:i:s");
			if ($res=$this->Site->save($this->request->data['Site'])){	
				$site_id=$res['Site']['id'];
				$this->Session->setFlash(__('Site has been added successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'add'));
			} else {
				$errors = $this->Site->validationErrors;
				foreach($errors as $err_val)
				{
					$error_arr[]=$err_val[0];
				}
				$imp_error=implode('\n',$error_arr);
				$this->Session->setFlash(__($imp_error), 'default', array('class' => 'error'));
			}
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdminChecker();
		$this->set('title_for_layout', __('Edit Site'));
		$this->Site->id = $id;
		$selected = "";
		
		$driver_detail = $this->Site->find("first",array("conditions"=>array("Site.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		
		if (!$this->Site->exists()) {
			throw new NotFoundException(__('Invalid Site'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			
			if($this->Session->read('Auth.User.role') !=1 && $this->Session->read('Auth.User.role') !=4)
			{
				$this->request->data['Site']['site_id']=$id;
				if($this->Session->read('Auth.User.role') !=1)
					$this->request->data['Site']['user_id']=$this->Auth->user('id');
				if ($res=$this->TempSite->saveAll($this->request->data['Site'])) {
					$site_id=$id;	
					$this->Session->setFlash(__('Admin is notified, he will approved your changes soon.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'edit',$id));
				}
			}
			else
			{
				if($this->Session->read('Auth.User.role') ==4)
				{
					unset($this->request->data['Site']['url']);
					$this->request->data['Site']['tested_edit_date_time']=date("Y-m-d H:i:s");
				}
				$this->request->data['Site']['id']=$id;
				if ($res=$this->Site->saveAll($this->request->data['Site'])) {	
					$site_id=$id;	
					$this->Session->setFlash(__('Site has been updated successfully.'), 'default', array('class' => 'success'));
					
					if($this->Session->read('Auth.User.role')=='4')
						$this->redirect(array('action' => 'index'));
					else
						$this->redirect(array('action' => 'edit',$id));
				}
			}
			$this->request->data = $this->Site->read(null, $id);
			$this->redirect(array('action' => 'edit',$id));
		} 
		$pre_data= $this->Site->find("first",array("conditions"=>array("Site.id"=>$id)));
		$this->request->data = $pre_data;
	}
	public function admin_view($id = null) {
		$this->checkSubAdminChecker();
		$this->set('title_for_layout', __('View Site'));
		$this->Site->id = $id;
		$selected = "";
		
		$driver_detail = $this->Site->find("first",array("conditions"=>array("Site.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		
		if (!$this->Site->exists()) {
			throw new NotFoundException(__('Invalid Site'));
		}
		
		$pre_data= $this->Site->find("first",array("conditions"=>array("Site.id"=>$id)));
		$this->set('sites', $pre_data);
	}
	public function admin_delete($id = null) {
		$this->checkSubAdmin();
		$this->Site->id = $id;
		if (!$this->Site->exists()) {
			throw new NotFoundException(__('Invalid Site'));
		}
		else
		{
			if($this->Session->read('Auth.User.role') !=1)
			{
				$arr['id']=$id;
				$arr['confirm_delete']=1;
				if ($res=$this->Site->saveAll($arr)) {
					$site_id=$id;	
					$this->Session->setFlash(__('Admin is notified, he will decide for delete.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				if ($this->Site->delete()) {
					$this->Session->setFlash(__('Site has been deleted successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				}
			}
		}
		$this->Session->setFlash(__('Site could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
	
	public function admin_download_csv()
	{
		Configure::write('debug',0);
		$this->autoRender = false;
		$this->Site->recursive = 0;
		
		if(isset($this->data['download']['search_url']) && $this->data['download']['search_url']!='') $search_url = $this->data['download']['search_url'];	
		else if(isset($this->params['named']['search_url']) && $this->params['named']['search_url']!='') $search_url = $this->request->data['Site']['search_url']=$this->params['named']['search_url'];
		
		if(isset($this->data['download']['search_article_price_from']) && $this->data['download']['search_article_price_from']!='') $search_article_price_from = $this->data['download']['search_article_price_from'];	
		else if(isset($this->params['named']['search_article_price_from']) && $this->params['named']['search_article_price_from']!='') $search_article_price_from =$this->request->data['Site']['search_article_price_from']=$this->params['named']['search_article_price_from'];
		
		if(isset($this->data['download']['search_article_price_to']) && $this->data['download']['search_article_price_to']!='') $search_article_price_to = $this->data['download']['search_article_price_to'];	
		else if(isset($this->params['named']['search_article_price_to']) && $this->params['named']['search_article_price_to']!='') $search_article_price_to = $this->request->data['Site']['search_article_price_to']=$this->params['named']['search_article_price_to'];
		
		if(isset($this->data['download']['search_article_duration_id']) && $this->data['download']['search_article_duration_id']!='') $search_article_duration_id = $this->data['download']['search_article_duration_id'];	
		else if(isset($this->params['named']['search_article_duration_id']) && $this->params['named']['search_article_duration_id']!='') $search_article_duration_id = $this->request->data['Site']['search_article_duration_id']=$this->params['named']['search_article_duration_id'];
		
		if(isset($this->data['download']['search_home_page_link_price_from']) && $this->data['download']['search_home_page_link_price_from']!='') $search_home_page_link_price_from = $this->data['download']['search_home_page_link_price_from'];	
		else if(isset($this->params['named']['search_home_page_link_price_from']) && $this->params['named']['search_home_page_link_price_from']!='') $search_home_page_link_price_from = $this->request->data['Site']['search_home_page_link_price_from']=$this->params['named']['search_home_page_link_price_from'];
		
		if(isset($this->data['download']['search_home_page_link_price_to']) && $this->data['download']['search_home_page_link_price_to']!='') $search_home_page_link_price_to = $this->data['download']['search_home_page_link_price_to'];	
		else if(isset($this->params['named']['search_home_page_link_price_to']) && $this->params['named']['search_home_page_link_price_to']!='') $search_home_page_link_price_to = $this->request->data['Site']['search_home_page_link_price_to']=$this->params['named']['search_home_page_link_price_to'];
		if(isset($this->data['download']['search_language_id']) && $this->data['download']['search_language_id']!='') $search_language_id = $this->data['download']['search_language_id'];	
		else if(isset($this->params['named']['search_language_id']) && $this->params['named']['search_language_id']!='') $search_language_id = $this->request->data['Site']['search_language_id']=$this->params['named']['search_language_id'];
		
		if(isset($this->data['download']['search_tf_id']) && $this->data['download']['search_tf_id']!='') $search_tf_id = $this->data['download']['search_tf_id'];	
		else if(isset($this->params['named']['search_tf_id']) && $this->params['named']['search_tf_id']!='') $search_tf_id = $this->request->data['Site']['search_tf_id']=$this->params['named']['search_tf_id'];
		
		if(isset($this->data['download']['search_cf_id']) && $this->data['download']['search_cf_id']!='') $search_cf_id = $this->data['download']['search_cf_id'];	
		else if(isset($this->params['named']['search_cf_id']) && $this->params['named']['search_cf_id']!='') $search_cf_id = $this->request->data['Site']['search_cf_id']=$this->params['named']['search_cf_id'];
		
		if(isset($this->data['download']['search_da_id']) && $this->data['download']['search_da_id']!='') $search_da_id = $this->data['download']['search_da_id'];	
		else if(isset($this->params['named']['search_da_id']) && $this->params['named']['search_da_id']!='') $search_da_id = $this->request->data['Site']['search_da_id']=$this->params['named']['search_da_id'];
		
		if(isset($this->data['download']['search_provider_contact']) && $this->data['download']['search_provider_contact']!='') $search_provider_contact = $this->data['download']['search_provider_contact'];	
		else if(isset($this->params['named']['search_provider_contact']) && $this->params['named']['search_provider_contact']!='') $search_provider_contact = $this->request->data['Site']['search_provider_contact']=$this->params['named']['search_provider_contact'];
		
		if(isset($this->data['download']['search_availability_id']) && $this->data['download']['search_availability_id']!='') $search_availability_id = $this->data['download']['search_availability_id'];	
		else if(isset($this->params['named']['search_availability_id']) && $this->params['named']['search_availability_id']!='') $search_availability_id = $this->request->data['Site']['search_availability_id']=$this->params['named']['search_availability_id'];
		
		if(isset($this->data['download']['search_theme_site_id']) && $this->data['download']['search_theme_site_id']!='') $search_theme_site_id = $this->data['download']['search_theme_site_id'];	
		else if(isset($this->params['named']['search_theme_site_id']) && $this->params['named']['search_theme_site_id']!='') $search_theme_site_id = $this->request->data['Site']['search_theme_site_id']=$this->params['named']['search_theme_site_id'];
		
		if(isset($this->data['download']['search_gambling_site_id']) && $this->data['download']['search_gambling_site_id']!='') $search_gambling_site_id = $this->data['download']['search_gambling_site_id'];	
		else if(isset($this->params['named']['search_gambling_site_id']) && $this->params['named']['search_gambling_site_id']!='') $search_gambling_site_id = $this->request->data['Site']['search_gambling_site_id']=$this->params['named']['search_gambling_site_id'];
		
		if(isset($this->data['download']['search_accept_gambling_id']) && $this->data['download']['search_accept_gambling_id']!='') $search_accept_gambling_id = $this->data['download']['search_accept_gambling_id'];	
		else if(isset($this->params['named']['search_accept_gambling_id']) && $this->params['named']['search_accept_gambling_id']!='') $search_accept_gambling_id = $this->request->data['Site']['search_accept_gambling_id']=$this->params['named']['search_accept_gambling_id'];
		
		if(isset($this->data['download']['search_accept_sport_betting_id']) && $this->data['download']['search_accept_sport_betting_id']!='') $search_accept_sport_betting_id = $this->data['download']['search_accept_sport_betting_id'];	
		else if(isset($this->params['named']['search_accept_sport_betting_id']) && $this->params['named']['search_accept_sport_betting_id']!='') $search_accept_sport_betting_id = $this->request->data['Site']['search_accept_sport_betting_id']=$this->params['named']['search_accept_sport_betting_id'];
		
		if(isset($this->data['download']['search_date_time_from']) && $this->data['download']['search_date_time_from']!='') $search_date_time_from = $this->data['download']['search_date_time_from'];	
		else if(isset($this->params['named']['search_date_time_from']) && $this->params['named']['search_date_time_from']!='') $search_date_time_from = $this->request->data['Site']['search_date_time_from']=$this->params['named']['search_date_time_from'];
				
		if(isset($this->data['download']['search_date_time_to']) && $this->data['download']['search_date_time_to']!='') $search_date_time_to = $this->data['download']['search_date_time_to'];	
		else if(isset($this->params['named']['search_date_time_to']) && $this->params['named']['search_date_time_to']!='') $search_date_time_to = $this->request->data['Site']['search_date_time_to']=$this->params['named']['search_date_time_to'];
		
		if(isset($this->data['download']['search_original_email_id']) && $this->data['download']['search_original_email_id']!='') $search_original_email_id = $this->data['download']['search_original_email_id'];	
		else if(isset($this->params['named']['search_original_email_id']) && $this->params['named']['search_original_email_id']!='') $search_original_email_id = $this->request->data['Site']['search_original_email_id']=$this->params['named']['search_original_email_id'];
		
		if(isset($this->data['download']['search_employee_id']) && $this->data['download']['search_employee_id']!='') $search_employee_id = $this->data['download']['search_employee_id'];	
		else if(isset($this->params['named']['search_employee_id']) && $this->params['named']['search_employee_id']!='') $search_employee_id = $this->request->data['Site']['search_employee_id']=$this->params['named']['search_employee_id'];		
		
		if(isset($this->data['download']['search_target_market_id']) && $this->data['download']['search_target_market_id']!='') $search_target_market_id = $this->data['download']['search_target_market_id'];	
		else if(isset($this->params['named']['search_target_market_id']) && $this->params['named']['search_target_market_id']!='') $search_target_market_id = $this->request->data['Site']['search_target_market_id']=$this->params['named']['search_target_market_id'];
		
		if(isset($this->data['download']['limit']) && $this->data['download']['limit']!='') $limit = $this->data['download']['limit'];	
		else if(isset($this->params['named']['limit']) && $this->params['named']['limit']!='') $limit = $this->request->data['Site']['limit']=$this->params['named']['limit'];
		
		//echo '<pre>';print_r($this->data['download']);
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($search_url))
		{
			$conditions['Site.url LIKE '] = '%'.$search_url.'%';
			$pagingArgs['search_url'] = $search_url;
		}
		if(!empty($search_article_price_from))
		{
			$conditions['Site.article_price >='] = $search_article_price_from;
			$pagingArgs['search_article_price_from'] = $search_article_price_from;
		}
		if(!empty($search_article_price_to))
		{
			$conditions['Site.article_price <='] = $search_article_price_to;
			$pagingArgs['search_article_price_to'] = $search_article_price_to;
		}
		if(!empty($search_article_duration_id))
		{
			$conditions['Site.article_duration_id'] = $search_article_duration_id;
			$pagingArgs['search_article_duration_id'] = $search_article_duration_id;
		}
		if(!empty($search_home_page_link_price_from))
		{
			$conditions['Site.home_page_link_price <='] = $search_home_page_link_price_from;
			$pagingArgs['search_home_page_link_price_from'] = $search_home_page_link_price_from;
		}
		if(!empty($search_home_page_link_price_to))
		{
			$conditions['Site.home_page_link_price >='] = $search_home_page_link_price_to;
			$pagingArgs['search_home_page_link_price_to'] = $search_home_page_link_price_to;
		}
		if(!empty($search_language_id))
		{
			$conditions['Site.language_id'] = $search_language_id;
			$pagingArgs['search_language_id'] = $search_language_id;
		}
		if(!empty($search_tf_id))
		{
			$conditions['Site.tf_id >= '] = $search_tf_id;
			$pagingArgs['search_tf_id'] = $search_tf_id;
		}		
		if(!empty($search_cf_id))
		{
			$conditions['Site.cf_id >= '] = $search_cf_id;
			$pagingArgs['search_cf_id'] = $search_cf_id;
		}	
		if(!empty($search_da_id))
		{
			$conditions['Site.da_id >= '] = $search_da_id;
			$pagingArgs['search_da_id'] = $search_da_id;
		}
		if(!empty($search_provider_contact))
		{
			$conditions['Site.provider_contact LIKE '] = '%'.$search_provider_contact.'%';
			$pagingArgs['search_provider_contact'] = $search_provider_contact;
		}
		if(!empty($search_availability_id))
		{
			$conditions['Site.availability_id'] = $search_availability_id;
			$pagingArgs['search_availability_id'] = $search_availability_id;
		}
		if(!empty($search_theme_site_id))
		{
			$conditions['Site.theme_site_id'] = $search_theme_site_id;
			$pagingArgs['search_theme_site_id'] = $search_theme_site_id;
		}
		if(!empty($search_gambling_site_id))
		{
			$conditions['Site.gambling_site_id'] = $search_gambling_site_id;
			$pagingArgs['search_gambling_site_id'] = $search_gambling_site_id;
		}
		if(!empty($search_accept_gambling_id))
		{
			$conditions['Site.accept_gambling_id'] = $search_accept_gambling_id;
			$pagingArgs['search_accept_gambling_id'] = $search_accept_gambling_id;
		}
		if(!empty($search_accept_sport_betting_id))
		{
			$conditions['Site.accept_sport_betting_id'] = $search_accept_sport_betting_id;
			$pagingArgs['search_accept_sport_betting_id'] = $search_accept_sport_betting_id;
		}
		if(!empty($search_gambling_site_id))
		{
			$conditions['Site.gambling_site_id'] = $search_gambling_site_id;
			$pagingArgs['search_gambling_site_id'] = $search_gambling_site_id;
		}
		if(!empty($date_time_from))
		{
			$conditions['Site.today_date >= '] = $search_date_time_from;
			$pagingArgs['date_time_from'] = $search_date_time_from;
		}
		if(!empty($date_time_to))
		{
			$conditions['Site.today_date <= '] = $search_date_time_to;
			$pagingArgs['date_time_to'] = $search_date_time_to;
		}
		if(!empty($original_email_id))
		{
			$conditions['Site.original_email_id'] = $search_original_email_id;
			$pagingArgs['original_email_id'] = $search_original_email_id;
		}
		if(!empty($employee_id))
		{
			$conditions['Site.employee_id'] = $search_employee_id;
			$pagingArgs['employee_id'] = $search_employee_id;
		}
		if(!empty($target_market_id))
		{
			$conditions['Site.target_market_id'] = $search_target_market_id;
			$pagingArgs['target_market_id'] = $search_target_market_id;
		}		
		$rows = $this->Site->find("all",array('order'=>array('Site.id'=>'DESC'),'conditions'=>$conditions));
		
		$namedate=__("Sites")."-".date("m.d.y");
		$file_type = "vnd.ms-excel";
		$file_ending = "csv";
		header("Content-Type: application/$file_type");
		header("Content-Disposition: attachment; filename=$namedate.$file_ending");
		header("Pragma: no-cache");
		header("Expires: 0");
		$title = __("Sites");
		$sep = ", ";
		$array_key=array(__("URL"),__("Source Email Id"),__("Currency"),__("Article Price"),__("Article Duration"),__("Writer Price Includes"),__("Home Page Link Price"),__("Home Page Link Duration"),__("Language"),__("TF"),__("CF"),__("DA"),__("Provider Contact"),__("Availability"),__("Theme of Site"),__("Gambling Site Type"),__("Accept Gambling"),__("Accept Sports Betting"),__("Today Date"),__("Original Email Id"),__("Target Market"),__("Topic Suggested by Provider"),__("Comment"),__("Operator"),__("Tested"),__("Date-time"));
		//start of printing column names as names of MySQL fields
		for ($i = 0; $i < count($array_key); $i++)
		{
			echo $array_key[$i] . ", ";
		}
		print("\n");
		foreach($rows as $site)
		{
			$source_email=$this->get_source_email($site['Site']['source_email_id']);
			$currency=$this->get_currency($site['Site']['currency_id']);
			$article_duration=$this->get_article_duration($site['Site']['article_duration_id']);
			$writing_price=$this->get_writing_price($site['Site']['writing_price_id']);
			$theme_site=$this->get_theme_site($site['Site']['theme_site_id']);
			$home_page_link_duration=$this->get_home_page_link_duration($site['Site']['home_page_link_duration_id']);
			$language=$this->get_language($site['Site']['language_id']);
			$tf=$this->get_tf($site['Site']['tf_id']);
			$cf=$this->get_cf($site['Site']['cf_id']);
			$da=$this->get_da($site['Site']['da_id']);
			$availability=$this->get_availability($site['Site']['availability_id']);
			$gambling_site=$this->get_gambling_site($site['Site']['gambling_site_id']);
			$accept_gambling=$this->get_accept_gambling($site['Site']['accept_gambling_id']);
			$accept_sport_betting=$this->get_accept_sport_betting($site['Site']['accept_sport_betting_id']);
			$target_market=$this->get_target_market($site['Site']['target_market_id']);
			$original_email=$this->get_original_email($site['Site']['original_email_id']);
			$operator=$this->get_operator($site['Site']['user_id']);
			if($sites['Site']['tested']=='2') $tested= 'Yes'; else $tested= 'No';
			
			$schema_insert = "";
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$site['Site']['url'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$source_email)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$currency)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$site['Site']['article_price'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$article_duration)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$writing_price)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$site['Site']['home_page_link_price'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$home_page_link_duration)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$language)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$tf)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$cf)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$da)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$site['Site']['provider_contact'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$availability)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$theme_site)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$gambling_site)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$accept_gambling)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$accept_sport_betting)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$site['Site']['today_date'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$original_email)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$target_market)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$site['Site']['topic_suggested'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$site['Site']['comment'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$operator)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$tested)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$site['Site']['date_time'])).$sep;
			$schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
			$schema_insert .= "\t";
			print(trim($schema_insert));
			print "\n";
		}
		exit;		
	}
	public function admin_upload_csv()
	{
		$this->checkSubAdmin();
		$user_id = $this->Auth->user('id');	
		$this->set("existing_url",'');	
		if ($this->request->is('post')) {
			$this->Site->create();
			if($this->Session->read('Auth.User.role') !=1)
				$this->request->data['Site']['user_id']=$this->Auth->user('id');	
			$this->request->data['Site']['date_time']			=	date("Y-m-d H:i:s");			
			if (($handle = fopen($this->request->data['Site']['csv_file']['tmp_name'], "r")) !== FALSE) {
			  $count=1;
			  while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				
				 if($count==1)
				 {
					$count++;
				 	continue;
				 }
				$arr['id']='';
				$siteurl=trim($data[0]);
				$siteurl=trim($siteurl,'/');
				$siteurl=str_replace('http://','',$siteurl);
				$siteurl=str_replace('www','',$siteurl);
				 $check_unique=$this->Site->find("first",array("conditions"=>array("Site.url LIKE"=>'%'.$siteurl.'%')));
				 if(!empty($check_unique))
				 {
				 	$existing_url[]=trim($data[0]);
					$article_price=trim($data[3]);
					if($article_price < $check_unique['Site']['article_price'])
						$arr['id']=$check_unique['Site']['id'];
				 }
				 if(empty($check_unique) || !empty($arr['id']))
				 {
					$arr['url']=trim($data[0]);
					$arr['source_email_id']=$this->get_source_email_id(trim($data[1]));
					$arr['currency_id']=$this->get_currency_id(trim($data[2]));
					$arr['article_price']=trim($data[3]);
					$arr['article_duration_id']=$this->get_article_duration_id(trim($data[4]));
					$arr['writing_price_id']=$this->get_writing_price_id(trim($data[5]));
					$arr['home_page_link_price']=trim($data[6]);	
					$arr['home_page_link_duration_id']=$this->get_home_page_link_duration_id(trim($data[7]));
					$arr['language_id']=$this->get_language_id(trim($data[8]));
					$arr['tf_id']=$this->get_tf_id(trim($data[9]));
					$arr['cf_id']=$this->get_cf_id(trim($data[10]));
					$arr['da_id']=$this->get_da_id(trim($data[11]));
					$arr['provider_contact']=trim($data[12]);	
					$arr['availability_id']=$this->get_availability_id(trim($data[13]));
					$arr['theme_site_id']=$this->get_theme_site_id(trim($data[14]));
					$arr['gambling_site_id']=$this->get_gambling_site_id(trim($data[15]));
					$arr['accept_gambling_id']=$this->get_accept_gambling_id(trim($data[16]));
					$arr['accept_sport_betting_id']=$this->get_accept_sport_betting_id(trim($data[17]));
					$arr['today_date']=trim($data[18]);	
					$arr['original_email_id']=$this->get_original_email_id(trim($data[19]));
					$arr['employee_id']=$this->get_employee_id(trim($data[20]));
					$arr['target_market_id']=$this->get_target_market_id(trim($data[21]));
					$arr['topic_suggested']=trim($data[22]);	
					$arr['comment']=trim($data[23]);	
					$arr['user_id']=$this->get_user_id(trim($data[24]));
					$arr['date_time']=date("Y-m-d H:i:s");
					$arr['status']=1;
					$arr['tested']=2;
					$res=$this->Site->save($arr);
					$count++;
				 }
			  }
			  fclose($handle);
			}
			$total_result=$count-2;
			if(!empty($existing_url))
			{
				$existing_url_list=implode('<br>',$existing_url);
				$existing_url_list='Existing Domains: <br>'.$existing_url_list;
			}
			$this->set("existing_url",$existing_url_list);	
			$this->Session->setFlash(__($total_result.' Sites has been added successfully.'), 'default', array('class' => 'success'));
		}
	}
	public function admin_upload_csv_url()
	{
		//Configure::write('debug',0);
		$this->checkAdmin();
		$user_id = $this->Auth->user('id');	
		$this->set("existing_url",'');	
		if ($this->request->is('post')) {
			$this->Site->create();
			if($this->Session->read('Auth.User.role') !=1)
				$this->request->data['Site']['user_id']=$this->Auth->user('id');	
			$this->request->data['Site']['date_time']			=	date("Y-m-d H:i:s");			
			if (($handle = fopen($this->request->data['Site']['csv_file']['tmp_name'], "r")) !== FALSE) {
			  $count=1;
					
			$namedate=__("Sites")."-".date("m.d.y");
			$file_type = "vnd.ms-excel";
			$file_ending = "csv";
			header("Content-Type: application/$file_type");
			header("Content-Disposition: attachment; filename=$namedate.$file_ending");
			header("Pragma: no-cache");
			header("Expires: 0");
			$title = __("Sites");
			$sep = ", ";
			$array_key=array(__("URL"),__("Article Price"),__("Article Duration"),__("Currency"),__("Language"),__("Availability"),__("Accept Gambling"),__("Accept Sports Betting"));
			for ($i = 0; $i < count($array_key); $i++)
			{
				echo $array_key[$i] . ", ";
			}
					print("\n");
			  while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				
				 if($count==1)
				 {
					$count++;
				 	continue;
				 }
				$arr['id']='';
				$siteurl=trim($data[0]);
				$siteurl=trim($siteurl,'/');
				$siteurl=str_replace('http://','',$siteurl);
				$siteurl=str_replace('www','',$siteurl);
				$check_unique=$this->Site->find("first",array("conditions"=>array("Site.url LIKE"=>'%'.$siteurl.'%')));
				 if(!empty($check_unique))
				 {
					$url=trim($check_unique['Site']['url']);
					$article_price=trim($check_unique['Site']['article_price']);
					$article_duration_id=trim($check_unique['Site']['article_duration_id']);
					$article_duration=$this->get_article_duration($article_duration_id);
					$currency=$this->get_currency($check_unique['Site']['currency_id']);
					$language=$this->get_language($check_unique['Site']['language_id']);					
					$availability=$this->get_availability($check_unique["Site"]['availability_id']);
					$accept_gambling=$this->get_accept_gambling($check_unique["Site"]['accept_gambling_id']);
					$accept_sport_betting=$this->get_accept_sport_betting($check_unique["Site"]['accept_sport_betting_id']);
						
					//start of printing column names as names of MySQL fields
					$schema_insert = "";
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$url)).$sep;
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$article_price)).$sep;
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$article_duration)).$sep;
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$currency)).$sep;
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$language)).$sep;
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$availability)).$sep;
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$accept_gambling)).$sep;
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$accept_sport_betting)).$sep;
					$schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
					$schema_insert .= "\t";
					print(trim($schema_insert));
					print "\n";
					
				 }
				 else
				 {
					$schema_insert = "";
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$data[0])).$sep;
					$schema_insert .= str_replace(',',';',str_replace(',',' ','not found')).$sep;
					$schema_insert .= ''.$sep;
					$schema_insert .= ''.$sep;
					$schema_insert .= ''.$sep;
					$schema_insert .= ''.$sep;
					$schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
					$schema_insert .= "\t";
					print(trim($schema_insert));
					print "\n";
				 }
			  }
			  fclose($handle);
					exit;
			}
		}
	}
	public function admin_search_file()
	{
		Configure::write('debug',2);
		$this->checkAdmin();
		$user_id = $this->Auth->user('id');	
		$this->set("existing_url",'');	
		if ($this->request->is('post')) {
			$result_arr=array();
			$count_i=-1;
			if (($handle = fopen($this->request->data['Site']['seach_file']['tmp_name'], "r")) !== FALSE) {
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
					if($count_i==-1)
					{
						$count_i++;
						continue;
					}	
					$siteurl=trim($data[0]);
					$siteurl=trim($siteurl,'/');
					$siteurl=str_replace('http://','',$siteurl);
					$siteurl=str_replace('https://','',$siteurl);
					$siteurl=str_replace('www.','',$siteurl);
					$result_arr[$count_i]['url']=$siteurl;
					$result_arr[$count_i]['currency']=trim($data[1]);
					$result_arr[$count_i]['article_price']=trim($data[2]);
					$result_arr[$count_i]['article_duration']=trim($data[3]);
					$result_arr[$count_i]['language']=trim($data[4]);
					$count_i++;
				}
			}
			if (($handle = fopen($this->request->data['Site']['csv_file']['tmp_name'], "r")) !== FALSE) {
			  $count=0;
					
			$namedate=__("Search")."-".date("m.d.y");
			$file_type = "vnd.ms-excel";
			$file_ending = "csv";
			header("Content-Type: application/$file_type");
			header("Content-Disposition: attachment; filename=$namedate.$file_ending");
			header("Pragma: no-cache");
			header("Expires: 0");
			$title = __("Sites");
			$sep = ", ";
			$array_key=array(__("URL"),__("Link"),__("DFRD"),__("Status"),__("Anchor"),__("Links to"),__("Currency"),__("Article Price"),__("Article Duration"),__("Language"));
			for ($i = 0; $i < count($array_key); $i++)
			{
				echo $array_key[$i] . ", ";
			}
			print("\n");
			  while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				
				 if($count==0)
				 {
					$count++;
				 	continue;
				 }
				$siteurl=trim($data[0]);
				$siteurl=trim($siteurl,'/');
				$siteurl=str_replace('http://','',$siteurl);
				$siteurl=str_replace('https://','',$siteurl);
				$siteurl=str_replace('www.','',$siteurl);
				$keys = array_keys($this->array_column($result_arr, 'url'), $siteurl);
				$schema_insert = "";
				$schema_insert .= str_replace(',',';',str_replace(',',' ',$data[0])).$sep;
				$schema_insert .= str_replace(',',';',str_replace(',',' ',$data[1])).$sep;
				$schema_insert .= str_replace(',',';',str_replace(',',' ',$data[2])).$sep;
				$schema_insert .= str_replace(',',';',str_replace(',',' ',$data[3])).$sep;
				$schema_insert .= str_replace(',',';',str_replace(',',' ',$data[4])).$sep;
				$schema_insert .= str_replace(',',';',str_replace(',',' ',$data[5])).$sep;
				if(!empty($keys))
				{
					$key_value=$keys[0];
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$result_arr[$key_value]['currency'])).$sep;
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$result_arr[$key_value]['article_price'])).$sep;
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$result_arr[$key_value]['article_duration'])).$sep;
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$result_arr[$key_value]['language'])).$sep;
				}
				else
				{
					$schema_insert .= 'NOT FOUND'.$sep;
					$schema_insert .= ''.$sep;
					$schema_insert .= ''.$sep;
					$schema_insert .= ''.$sep;
				}
				
				$schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
				$schema_insert .= "\t";
				print(trim($schema_insert));
				print "\n";
				
			  }
			  fclose($handle);
					exit;
			}
		}
	}
	public function admin_word_input()
	{
		$this->checkAdmin();
		$user_id = $this->Auth->user('id');	
		$this->set("existing_url",'');	
		if ($this->request->is('post')) {			
			if (($handle = fopen($this->request->data['Site']['csv_file']['tmp_name'], "r")) !== FALSE) {
			  $count=0;
				
				$namedate=__("Word-input")."-".date("m.d.y");
				header("Content-type: application/vnd.ms-word");
				header("Content-Disposition: attachment;Filename=".$namedate.".doc");
				
				echo "<html>";
				echo "<body>";
				echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=Windows-1252\">";
			  	while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				 if($count==0)
				 {
					$count++;
				 	continue;
				 }
				echo "<p><b>Article ".$count." :</b></p>";
				echo '<p>Article to be publish on '.$data[0].'  so write article matched to site theme</p>'; 
				echo '<p>Links to : <a href="'.$data[2].'">'.$data[2].'</a></p>';
				echo '<p>anchor : '.$data[1].'</p>';
				echo '<p></p><p></p>';
				$count++;
			  }
				echo "</body>";
				echo "</html>";
			  fclose($handle);
			}
		}
	}
	public function admin_confirmation_delete($id=NULL) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->Site->recursive = 0;
		$limit=$this->get_application_setting('result_limit');
		if(isset($this->data['Site']['user_id']) && $this->data['Site']['user_id']!='') $user_id = $this->data['Site']['user_id'];	
		else if(isset($this->params['named']['user_id']) && $this->params['named']['user_id']!='') $user_id = $this->request->data['Site']['user_id']=$this->params['named']['user_id'];
		
		if(isset($this->data['Site']['url']) && $this->data['Site']['url']!='') $url = $this->data['Site']['url'];	
		else if(isset($this->params['named']['url']) && $this->params['named']['url']!='') $url = $this->request->data['Site']['url']=$this->params['named']['url'];
		
		if(isset($this->data['Site']['article_price_from']) && $this->data['Site']['article_price_from']!='') $article_price_from = $this->data['Site']['article_price_from'];	
		else if(isset($this->params['named']['article_price_from']) && $this->params['named']['article_price_from']!='') $article_price_from =$this->request->data['Site']['article_price_from']=$this->params['named']['article_price_from'];
		
		if(isset($this->data['Site']['article_price_to']) && $this->data['Site']['article_price_to']!='') $article_price_to = $this->data['Site']['article_price_to'];	
		else if(isset($this->params['named']['article_price_to']) && $this->params['named']['article_price_to']!='') $article_price_to = $this->request->data['Site']['article_price_to']=$this->params['named']['article_price_to'];
		
		if(isset($this->data['Site']['article_duration_id']) && $this->data['Site']['article_duration_id']!='') $article_duration_id = $this->data['Site']['article_duration_id'];	
		else if(isset($this->params['named']['article_duration_id']) && $this->params['named']['article_duration_id']!='') $article_duration_id = $this->request->data['Site']['article_duration_id']=$this->params['named']['article_duration_id'];
		
		if(isset($this->data['Site']['home_page_link_price_from']) && $this->data['Site']['home_page_link_price_from']!='') $home_page_link_price_from = $this->data['Site']['home_page_link_price_from'];	
		else if(isset($this->params['named']['home_page_link_price_from']) && $this->params['named']['home_page_link_price_from']!='') $home_page_link_price_from = $this->request->data['Site']['home_page_link_price_from']=$this->params['named']['home_page_link_price_from'];
		
		if(isset($this->data['Site']['home_page_link_price_to']) && $this->data['Site']['home_page_link_price_to']!='') $home_page_link_price_to = $this->data['Site']['home_page_link_price_to'];	
		else if(isset($this->params['named']['home_page_link_price_to']) && $this->params['named']['home_page_link_price_to']!='') $home_page_link_price_to = $this->request->data['Site']['home_page_link_price_to']=$this->params['named']['home_page_link_price_to'];
		if(isset($this->data['Site']['language_id']) && $this->data['Site']['language_id']!='') $language_id = $this->data['Site']['language_id'];	
		else if(isset($this->params['named']['language_id']) && $this->params['named']['language_id']!='') $language_id = $this->request->data['Site']['language_id']=$this->params['named']['language_id'];
		
		if(isset($this->data['Site']['tf_id']) && $this->data['Site']['tf_id']!='') $tf_id = $this->data['Site']['tf_id'];	
		else if(isset($this->params['named']['tf_id']) && $this->params['named']['tf_id']!='') $tf_id = $this->request->data['Site']['tf_id']=$this->params['named']['tf_id'];
		
		if(isset($this->data['Site']['cf_id']) && $this->data['Site']['cf_id']!='') $cf_id = $this->data['Site']['cf_id'];	
		else if(isset($this->params['named']['cf_id']) && $this->params['named']['cf_id']!='') $cf_id = $this->request->data['Site']['cf_id']=$this->params['named']['cf_id'];
		
		if(isset($this->data['Site']['da_id']) && $this->data['Site']['da_id']!='') $da_id = $this->data['Site']['da_id'];	
		else if(isset($this->params['named']['da_id']) && $this->params['named']['da_id']!='') $da_id = $this->request->data['Site']['da_id']=$this->params['named']['da_id'];
		
		if(isset($this->data['Site']['provider_contact']) && $this->data['Site']['provider_contact']!='') $provider_contact = $this->data['Site']['provider_contact'];	
		else if(isset($this->params['named']['provider_contact']) && $this->params['named']['provider_contact']!='') $provider_contact = $this->request->data['Site']['provider_contact']=$this->params['named']['provider_contact'];
		
		if(isset($this->data['Site']['availability_id']) && $this->data['Site']['availability_id']!='') $availability_id = $this->data['Site']['availability_id'];	
		else if(isset($this->params['named']['availability_id']) && $this->params['named']['availability_id']!='') $availability_id = $this->request->data['Site']['availability_id']=$this->params['named']['availability_id'];
		
		if(isset($this->data['Site']['type_site']) && $this->data['Site']['type_site']!='') $type_site = $this->data['Site']['type_site'];	
		else if(isset($this->params['named']['type_site']) && $this->params['named']['type_site']!='') $type_site = $this->request->data['Site']['type_site']=$this->params['named']['type_site'];
		
		if(isset($this->data['Site']['theme_site_id']) && $this->data['Site']['theme_site_id']!='') $theme_site_id = $this->data['Site']['theme_site_id'];	
		else if(isset($this->params['named']['theme_site_id']) && $this->params['named']['theme_site_id']!='') $theme_site_id = $this->request->data['Site']['theme_site_id']=$this->params['named']['theme_site_id'];
		
		if(isset($this->data['Site']['gambling_site_id']) && $this->data['Site']['gambling_site_id']!='') $gambling_site_id = $this->data['Site']['gambling_site_id'];	
		else if(isset($this->params['named']['gambling_site_id']) && $this->params['named']['gambling_site_id']!='') $gambling_site_id = $this->request->data['Site']['gambling_site_id']=$this->params['named']['gambling_site_id'];
		
		if(isset($this->data['Site']['accept_gambling_id']) && $this->data['Site']['accept_gambling_id']!='') $accept_gambling_id = $this->data['Site']['accept_gambling_id'];	
		else if(isset($this->params['named']['accept_gambling_id']) && $this->params['named']['accept_gambling_id']!='') $accept_gambling_id = $this->request->data['Site']['accept_gambling_id']=$this->params['named']['accept_gambling_id'];
		
		if(isset($this->data['Site']['accept_sport_betting_id']) && $this->data['Site']['accept_sport_betting_id']!='') $accept_sport_betting_id = $this->data['Site']['accept_sport_betting_id'];	
		else if(isset($this->params['named']['accept_sport_betting_id']) && $this->params['named']['accept_sport_betting_id']!='') $accept_sport_betting_id = $this->request->data['Site']['accept_sport_betting_id']=$this->params['named']['accept_sport_betting_id'];
		
		if(isset($this->data['Site']['date_time_from']) && $this->data['Site']['date_time_from']!='') $date_time_from = $this->data['Site']['date_time_from'];	
		else if(isset($this->params['named']['date_time_from']) && $this->params['named']['date_time_from']!='') $date_time_from = $this->request->data['Site']['date_time_from']=$this->params['named']['date_time_from'];
				
		if(isset($this->data['Site']['date_time_to']) && $this->data['Site']['date_time_to']!='') $date_time_to = $this->data['Site']['date_time_to'];	
		else if(isset($this->params['named']['date_time_to']) && $this->params['named']['date_time_to']!='') $date_time_to = $this->request->data['Site']['date_time_to']=$this->params['named']['date_time_to'];
		
		if(isset($this->data['Site']['original_email_id']) && $this->data['Site']['original_email_id']!='') $original_email_id = $this->data['Site']['original_email_id'];	
		else if(isset($this->params['named']['original_email_id']) && $this->params['named']['original_email_id']!='') $original_email_id = $this->request->data['Site']['original_email_id']=$this->params['named']['original_email_id'];
		
		if(isset($this->data['Site']['employee_id']) && $this->data['Site']['employee_id']!='') $employee_id = $this->data['Site']['employee_id'];	
		else if(isset($this->params['named']['employee_id']) && $this->params['named']['employee_id']!='') $employee_id = $this->request->data['Site']['employee_id']=$this->params['named']['employee_id'];		
		
		if(isset($this->data['Site']['target_market_id']) && $this->data['Site']['target_market_id']!='') $target_market_id = $this->data['Site']['target_market_id'];	
		else if(isset($this->params['named']['target_market_id']) && $this->params['named']['target_market_id']!='') $target_market_id = $this->request->data['Site']['target_market_id']=$this->params['named']['target_market_id'];
		
		if(isset($this->data['Site']['limit']) && $this->data['Site']['limit']!='') $limit = $this->data['Site']['limit'];	
		else if(isset($this->params['named']['limit']) && $this->params['named']['limit']!='') $limit = $this->request->data['Site']['limit']=$this->params['named']['limit'];
		
		$conditions = array("confirm_delete"=>1); 
		$pagingArgs = array(); 
		//echo '<pre>';print_r($this->data['Site']);
		if($this->Session->read('Auth.User.role') !=1)
			$conditions['Site.user_id']=$this->Auth->user('id');
		if(!empty($url))
		{
			$conditions['Site.url LIKE '] = '%'.$url.'%';
			$pagingArgs['url'] = $url;
		}
		if(!empty($article_price_from))
		{
			$conditions['Site.article_price >='] = $article_price_from;
			$pagingArgs['article_price_from'] = $article_price_from;
		}
		if(!empty($article_price_to))
		{
			$conditions['Site.article_price <='] = $article_price_to;
			$pagingArgs['article_price_to'] = $article_price_to;
		}
		if(!empty($article_duration_id))
		{
			$conditions['Site.article_duration_id'] = $article_duration_id;
			$pagingArgs['article_duration_id'] = $article_duration_id;
		}
		if(!empty($home_page_link_price_from))
		{
			$conditions['Site.home_page_link_price <='] = $home_page_link_price_from;
			$pagingArgs['home_page_link_price_from'] = $home_page_link_price_from;
		}
		if(!empty($home_page_link_price_to))
		{
			$conditions['Site.home_page_link_price >='] = $home_page_link_price_to;
			$pagingArgs['home_page_link_price_to'] = $home_page_link_price_to;
		}
		if(!empty($language_id))
		{
			$conditions['Site.language_id'] = $language_id;
			$pagingArgs['language_id'] = $language_id;
		}
		if(!empty($tf_id))
		{
			$conditions['Site.tf_id'] = $tf_id;
			$pagingArgs['tf_id'] = $tf_id;
		}		
		if(!empty($cf_id))
		{
			$conditions['Site.cf_id'] = $cf_id;
			$pagingArgs['cf_id'] = $cf_id;
		}	
		if(!empty($da_id))
		{
			$conditions['Site.da_id'] = $da_id;
			$pagingArgs['da_id'] = $da_id;
		}
		if(!empty($provider_contact))
		{
			$conditions['Site.provider_contact LIKE '] = '%'.$provider_contact.'%';
			$pagingArgs['provider_contact'] = $provider_contact;
		}
		if(!empty($availability_id))
		{
			$conditions['Site.availability_id'] = $availability_id;
			$pagingArgs['availability_id'] = $availability_id;
		}
		if(!empty($type_site))
		{
			$conditions['Site.type_site LIKE '] = '%'.$type_site.'%';
			$pagingArgs['type_site'] = $type_site;
		}
		if(!empty($theme_site_id))
		{
			$conditions['Site.theme_site_id'] = $theme_site_id;
			$pagingArgs['theme_site_id'] = $theme_site_id;
		}
		if(!empty($gambling_site_id))
		{
			$conditions['Site.gambling_site_id'] = $gambling_site_id;
			$pagingArgs['gambling_site_id'] = $gambling_site_id;
		}
		if(!empty($accept_gambling_id))
		{
			$conditions['Site.accept_gambling_id'] = $accept_gambling_id;
			$pagingArgs['accept_gambling_id'] = $accept_gambling_id;
		}
		if(!empty($accept_sport_betting_id))
		{
			$conditions['Site.accept_sport_betting_id'] = $accept_sport_betting_id;
			$pagingArgs['accept_sport_betting_id'] = $accept_sport_betting_id;
		}
		if(!empty($gambling_site_id))
		{
			$conditions['Site.gambling_site_id'] = $gambling_site_id;
			$pagingArgs['gambling_site_id'] = $gambling_site_id;
		}
		if(!empty($date_time_from))
		{
			$conditions['Site.date_time >= '] = $date_time_from;
			$pagingArgs['date_time_from'] = $date_time_from;
		}
		if(!empty($date_time_to))
		{
			$conditions['Site.date_time <= '] = $date_time_to;
			$pagingArgs['date_time_to'] = $date_time_to;
		}
		if(!empty($original_email_id))
		{
			$conditions['Site.original_email_id'] = $original_email_id;
			$pagingArgs['original_email_id'] = $original_email_id;
		}
		if(!empty($employee_id))
		{
			$conditions['Site.employee_id'] = $employee_id;
			$pagingArgs['employee_id'] = $employee_id;
		}
		if(!empty($target_market_id))
		{
			$conditions['Site.target_market_id'] = $target_market_id;
			$pagingArgs['target_market_id'] = $target_market_id;
		}
		if(!empty($user_id))
		{
			$conditions['Site.user_id'] = $user_id;
			$pagingArgs['user_id'] = $user_id;
		}
		if(!empty($limit))
		{
			$pagingArgs['limit'] = $limit;
		}
		//echo '<pre>';print_r($conditions);
		$this->set("pagingArgs",$pagingArgs);	
		$this->paginate = array(
			  'limit'=>$limit,
			  'order'=>array('Site.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('sites', $rows);
		if(isset($this->request->params['named']['page']) && $this->request->params['named']['page'])
			$page_no=($this->request->params['named']['page']-1)*$limit;
		else
			$page_no=0;
		$this->set("page_no",$page_no);
		
		$this->params['page_title'] = "Site";
		if($id != null){
		$this->Site->id = $id;
		if (!$this->Site->exists()) {
			throw new NotFoundException(__('Invalid Site'));
		}
		}
		
		if ($this->request->is('post') || $this->request->is('put')) {
			if($this->request->data['task_value']=='Delete')
				$this->Site->deleteAll(array('Site.id' => $this->request->data['frmList']['ID']), false);
		}
	}
	
	public function admin_confirm_delete($id = null) {
		$this->checkAdmin();
		$this->Site->id = $id;
		if (!$this->Site->exists()) {
			throw new NotFoundException(__('Invalid Site'));
		}
		else
		{
			if ($this->Site->delete()) {
				$this->Session->setFlash(__('Site has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'confirmation_delete'));
			}
		}
		$this->Session->setFlash(__('Site could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'confirmation_delete'));
	}	
	public function admin_delete_view($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit Site'));
		$this->Site->id = $id;
		$selected = "";
		
		$this->set("id",$id);
		
		if (!$this->Site->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		
		$pre_data= $this->Site->find("first",array("conditions"=>array("Site.id"=>$id)));
		$this->set('sites', $pre_data);
	}	
	public function admin_upload_csv_availability()
	{
		//Configure::write('debug',0);
		$this->checkAdmin();
		$user_id = $this->Auth->user('id');	
		$this->set("existing_url",'');	
		if ($this->request->is('post')) {
			$this->Site->create();
			if($this->Session->read('Auth.User.role') !=1)
				$this->request->data['Site']['user_id']=$this->Auth->user('id');	
			$this->request->data['Site']['date_time']			=	date("Y-m-d H:i:s");			
			if (($handle = fopen($this->request->data['Site']['csv_file']['tmp_name'], "r")) !== FALSE) {
			  $count=1;
					
			$namedate=__("Availability")."-".date("m.d.y");
			$file_type = "vnd.ms-excel";
			$file_ending = "csv";
			header("Content-Type: application/$file_type");
			header("Content-Disposition: attachment; filename=$namedate.$file_ending");
			header("Pragma: no-cache");
			header("Expires: 0");
			$title = __("Availability");
			$sep = ", ";
			  while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				
				$schema_insert = "";
				 if($count==1)
				 {
					$count++;
					for ($i = 0; $i < count($data); $i++)
					{
						//echo $data[$i] . ", ";
						$schema_insert .= str_replace(',',';',str_replace(',',' ',$data[$i])).$sep;
					}
					$schema_insert .='Availability';
				 }
				 else
				 {
					$count_field=count($data);
					for($m=0;$m<$count_field;$m++)
					{
						$schema_insert .= str_replace(',',';',str_replace(',',' ',$data[$m])).$sep;
					}
					$arr['id']='';
					$siteurl=trim($data[0]);
					$siteurl=trim($siteurl,'/');
					$siteurl=str_replace('http://','',$siteurl);
					$siteurl=str_replace('www','',$siteurl);
					$check_unique=$this->Site->find("first",array("conditions"=>array("Site.url LIKE"=>'%'.$siteurl.'%')));
					
					if(!empty($check_unique))
						$availability=$this->get_availability($check_unique["Site"]['availability_id']);
					else
						$availability='';
					echo $availability;
					$schema_insert .= str_replace(',',';',str_replace(',',' ',$availability)).$sep;
					
				 }
				$schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
				$schema_insert .= "\t";
				print(trim($schema_insert));
				print "\n";	
				
			  }
			  fclose($handle);
					exit;
			}
		}
	}
}
