<?php
App::uses('AppController', 'Controller');
class EmployeeErrorsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('EmployeeError','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'EmployeeError.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->EmployeeError->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->EmployeeError->updateAll(array("EmployeeError.status"=>'0'),array("EmployeeError.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->EmployeeError->updateAll(array("EmployeeError.status"=>'1'),array("EmployeeError.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->EmployeeError->updateAll(array("EmployeeError.show_home"=>'1'),array("EmployeeError.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->EmployeeError->updateAll(array("EmployeeError.show_home"=>'0'),array("EmployeeError.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->EmployeeError->deleteAll(array('EmployeeError.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['EmployeeError']['title']) && $this->data['EmployeeError']['title']!='') $title = $this->data['EmployeeError']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['EmployeeError']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['EmployeeError.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');		
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('EmployeeError.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('employee_errors', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add EmployeeError'));
		if ($this->request->is('post')) {
			$this->EmployeeError->create();	
			$pre_title_check = $this->EmployeeError->find("count",array("conditions"=>array("EmployeeError.title"=>$this->request->data['EmployeeError']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['EmployeeError']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->EmployeeError->save($this->request->data['EmployeeError'])){
					$this->Session->setFlash(__('Error has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Error could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Error title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit EmployeeError'));
		$this->EmployeeError->id = $id;
		$selected = "";
		
		$driver_detail = $this->EmployeeError->find("first",array("conditions"=>array("EmployeeError.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->EmployeeError->exists()) {
			throw new NotFoundException(__('Invalid employee_error'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['EmployeeError']['id']=$id;		
			$pre_title_check = $this->EmployeeError->find("count",array("conditions"=>array("EmployeeError.title"=>$this->request->data['EmployeeError']['title'],"EmployeeError.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->EmployeeError->saveAll($this->request->data['EmployeeError'])) {
					$this->Session->setFlash(__('Error has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Error could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Error title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->EmployeeError->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->EmployeeError->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->EmployeeError->id = $id;
		if (!$this->EmployeeError->exists()) {
			throw new NotFoundException(__('Invalid Error'));
		}
		else
		{
			if ($this->EmployeeError->delete()) {
				$this->Session->setFlash(__('Error has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Error could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
