<?php
App::uses('AppController', 'Controller');
class DealWriterNamesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('DealWriterName','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'DealWriterName.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkLogin();
		$this->set('title_for_layout', __('Admin'));
		$this->DealWriterName->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->DealWriterName->updateAll(array("DealWriterName.status"=>'0'),array("DealWriterName.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->DealWriterName->updateAll(array("DealWriterName.status"=>'1'),array("DealWriterName.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->DealWriterName->updateAll(array("DealWriterName.show_home"=>'1'),array("DealWriterName.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->DealWriterName->updateAll(array("DealWriterName.show_home"=>'0'),array("DealWriterName.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->DealWriterName->deleteAll(array('DealWriterName.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['DealWriterName']['title']) && $this->data['DealWriterName']['title']!='') $title = $this->data['DealWriterName']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['DealWriterName']['title']=$this->params['named']['title'];
		
		if(isset($this->data['DealWriterName']['language_search']) && $this->data['DealWriterName']['language_search']!='') $language_search = $this->data['DealWriterName']['language_search'];	
		else if(isset($this->params['named']['language_search']) && $this->params['named']['language_search']!='') $language_search = $this->request->data['DealWriterName']['language_search']=$this->params['named']['language_search'];
		
		if(isset($this->data['DealWriterName']['writer_availability_id']) && $this->data['DealWriterName']['writer_availability_id']!='') $writer_availability_id = $this->data['DealWriterName']['writer_availability_id'];	
		else if(isset($this->params['named']['writer_availability_id']) && $this->params['named']['writer_availability_id']!='') $writer_availability_id = $this->request->data['DealWriterName']['writer_availability_id']=$this->params['named']['writer_availability_id'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($language_search))
		{
			//$conditions	=array("OR"=>array('DealWriterName.language LIKE '=>','.$language_search.'%','DealWriterName.language LIKE '=>'%'.$language_search.','));
			$conditions['DealWriterName.language LIKE '] = '%'.$language_search.'%';
			$pagingArgs['language_search'] = $language_search;
		}
		if(!empty($title))
		{
			$conditions['DealWriterName.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		if(!empty($writer_availability_id))
		{
			$conditions['DealWriterName.writer_availability_id'] = $writer_availability_id;
			$pagingArgs['writer_availability_id'] = $writer_availability_id;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');			
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('DealWriterName.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('deal_writer_names', $rows);
	}
	public function admin_add() {
		$this->checkLogin();
		$this->set('title_for_layout', __('Add DealWriterName'));
		if ($this->request->is('post')) {
			$this->DealWriterName->create();	
			$pre_title_check = $this->DealWriterName->find("count",array("conditions"=>array("DealWriterName.title"=>$this->request->data['DealWriterName']['title'])));
			if($pre_title_check==0)
			{
				$imp=implode(',',$this->request->data['DealWriterName']['language']);
				unset($this->request->data['DealWriterName']['language']);
				$this->request->data['DealWriterName']['language']=trim($imp);
				$this->request->data['DealWriterName']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->DealWriterName->save($this->request->data['DealWriterName'])){
					$this->Session->setFlash(__('Deal Writer Names has been added successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Deal Writer Names could not be added.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Deal Writer Names title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkLogin();
		$this->set('title_for_layout', __('Edit DealWriterName'));
		$this->DealWriterName->id = $id;
		$selected = "";
		
		$driver_detail = $this->DealWriterName->find("first",array("conditions"=>array("DealWriterName.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->DealWriterName->exists()) {
			throw new NotFoundException(__('Invalid deal_writer_name'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['DealWriterName']['id']=$id;		
			$pre_title_check = $this->DealWriterName->find("count",array("conditions"=>array("DealWriterName.title"=>$this->request->data['DealWriterName']['title'],"DealWriterName.id <>"=>$id)));
			if($pre_title_check==0)
			{
				$imp=implode(',',$this->request->data['DealWriterName']['language']);
				unset($this->request->data['DealWriterName']['language']);
				$this->request->data['DealWriterName']['language']=trim($imp);
				if ($res=$this->DealWriterName->saveAll($this->request->data['DealWriterName'])) {
					$this->Session->setFlash(__('Deal Writer Names has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Deal Writer Names could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Deal Writer Names title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->DealWriterName->read(null, $id);
			$this->redirect(array('action' => 'index'));
		}
		$data=$this->DealWriterName->read(null, $id);
		$explode=explode(",",$data['DealWriterName']['language']);
		unset($data['DealWriterName']['language']);
		$data['DealWriterName']['language']=$explode;
		$this->request->data = $data;	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->DealWriterName->id = $id;
		if (!$this->DealWriterName->exists()) {
			throw new NotFoundException(__('Invalid Deal Writer Names'));
		}
		else
		{
			if ($this->DealWriterName->delete()) {
				$this->Session->setFlash(__('Deal Writer Names has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Deal Writer Names could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
	public function get_comment($id=NULL)
	{
		$this->checkAdmin();
		$this->autoRender=false;
		$comment_de=$this->DealWriterName->read(null, $id);
		echo $comment_de['DealWriterName']['comment'];
	}
}
