<?php
App::uses('AppController', 'Controller');
class ClientSitesController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('ClientSite','EmailTemplate','ApplicationSetting','TempClientSite','Site','ClientSiteRecord','ClientSiteUrl','GroupLanguage','GroupTheme');
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'ClientSite.id' => 'desc'
        )
    );
	public function beforeFilter() {
        parent::beforeFilter();
	}	
	public function admin_index($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->ClientSite->recursive = 0;
		$limit=$this->get_application_setting('result_limit');
		
		if ($this->request->is('post') || $this->request->is('put')) {
			if($this->request->data['task_value']=='DeActive')
				$this->ClientSite->updateAll(array("ClientSite.status"=>'0'),array("ClientSite.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
			{
				$this->ClientSite->updateAll(array("ClientSite.status"=>'1'),array("ClientSite.id"=>$this->request->data['frmList']['ID']));
				foreach($this->request->data['frmList']['ID'] as $userid)
				{
					$this->add_client_site_data($userid);
				}
			}
			else if($this->request->data['task_value']=='Delete')
				$this->ClientSite->deleteAll(array('ClientSite.id' => $this->request->data['frmList']['ID']), false);
		}
		
		if(isset($this->data['ClientSite']['user_id']) && $this->data['ClientClientSite']['user_id']!='') $user_id = $this->data['ClientClientSite']['user_id'];	
		else if(isset($this->params['named']['user_id']) && $this->params['named']['user_id']!='') $user_id = $this->request->data['ClientClientSite']['user_id']=$this->params['named']['user_id'];
		
		if(isset($this->data['ClientSite']['client_id']) && $this->data['ClientSite']['client_id']!='') $client_id = $this->data['ClientSite']['client_id'];	
		else if(isset($this->params['named']['client_id']) && $this->params['named']['client_id']!='') $client_id = $this->request->data['ClientSite']['client_id']=$this->params['named']['client_id'];		
		
		if(isset($this->data['ClientSite']['url']) && $this->data['ClientSite']['url']!='') $url = $this->data['ClientSite']['url'];	
		else if(isset($this->params['named']['url']) && $this->params['named']['url']!='') $url = $this->request->data['ClientSite']['url']=$this->params['named']['url'];
		
		if(isset($this->data['ClientSite']['article_duration_id']) && $this->data['ClientSite']['article_duration_id']!='') $article_duration_id = $this->data['ClientSite']['article_duration_id'];	
		else if(isset($this->params['named']['article_duration_id']) && $this->params['named']['article_duration_id']!='') $article_duration_id = $this->request->data['ClientSite']['article_duration_id']=$this->params['named']['article_duration_id'];
		
		if(isset($this->data['ClientSite']['language_id']) && $this->data['ClientSite']['language_id']!='') $language_id = $this->data['ClientSite']['language_id'];	
		else if(isset($this->params['named']['language_id']) && $this->params['named']['language_id']!='') $language_id = $this->request->data['ClientSite']['language_id']=$this->params['named']['language_id'];
		
		if(isset($this->data['ClientSite']['availability_id']) && $this->data['ClientSite']['availability_id']!='') $availability_id = $this->data['ClientSite']['availability_id'];	
		else if(isset($this->params['named']['availability_id']) && $this->params['named']['availability_id']!='') $availability_id = $this->request->data['ClientSite']['availability_id']=$this->params['named']['availability_id'];
		
		if(isset($this->data['ClientSite']['accept_gambling_id']) && $this->data['ClientSite']['accept_gambling_id']!='') $accept_gambling_id = $this->data['ClientSite']['accept_gambling_id'];	
		else if(isset($this->params['named']['accept_gambling_id']) && $this->params['named']['accept_gambling_id']!='') $accept_gambling_id = $this->request->data['ClientSite']['accept_gambling_id']=$this->params['named']['accept_gambling_id'];
		
		if(isset($this->data['ClientSite']['accept_sport_betting_id']) && $this->data['ClientSite']['accept_sport_betting_id']!='') $accept_sport_betting_id = $this->data['ClientSite']['accept_sport_betting_id'];	
		else if(isset($this->params['named']['accept_sport_betting_id']) && $this->params['named']['accept_sport_betting_id']!='') $accept_sport_betting_id = $this->request->data['ClientSite']['accept_sport_betting_id']=$this->params['named']['accept_sport_betting_id'];
		
		if(isset($this->data['ClientSite']['theme_site_id']) && $this->data['ClientSite']['theme_site_id']!='') $theme_site_id = $this->data['ClientSite']['theme_site_id'];	
		else if(isset($this->params['named']['theme_site_id']) && $this->params['named']['theme_site_id']!='') $theme_site_id = $this->request->data['ClientSite']['theme_site_id']=$this->params['named']['theme_site_id'];
		
		if(isset($this->data['ClientSite']['article_price_from']) && $this->data['ClientSite']['article_price_from']!='') $article_price_from = $this->data['ClientSite']['article_price_from'];	
		else if(isset($this->params['named']['article_price_from']) && $this->params['named']['article_price_from']!='') $article_price_from =$this->request->data['ClientSite']['article_price_from']=$this->params['named']['article_price_from'];
		
		if(isset($this->data['ClientSite']['article_price_to']) && $this->data['ClientSite']['article_price_to']!='') $article_price_to = $this->data['ClientSite']['article_price_to'];	
		else if(isset($this->params['named']['article_price_to']) && $this->params['named']['article_price_to']!='') $article_price_to = $this->request->data['ClientSite']['article_price_to']=$this->params['named']['article_price_to'];
		
		if(isset($this->data['ClientSite']['home_page_link_price_from']) && $this->data['ClientSite']['home_page_link_price_from']!='') $home_page_link_price_from = $this->data['ClientSite']['home_page_link_price_from'];	
		else if(isset($this->params['named']['home_page_link_price_from']) && $this->params['named']['home_page_link_price_from']!='') $home_page_link_price_from = $this->request->data['ClientSite']['home_page_link_price_from']=$this->params['named']['home_page_link_price_from'];
		
		if(isset($this->data['ClientSite']['home_page_link_price_to']) && $this->data['ClientSite']['home_page_link_price_to']!='') $home_page_link_price_to = $this->data['ClientSite']['home_page_link_price_to'];	
		else if(isset($this->params['named']['home_page_link_price_to']) && $this->params['named']['home_page_link_price_to']!='') $home_page_link_price_to = $this->request->data['ClientSite']['home_page_link_price_to']=$this->params['named']['home_page_link_price_to'];
		
		if(isset($this->data['ClientSite']['tf_id']) && $this->data['ClientSite']['tf_id']!='') $tf_id = $this->data['ClientSite']['tf_id'];	
		else if(isset($this->params['named']['tf_id']) && $this->params['named']['tf_id']!='') $tf_id = $this->request->data['ClientSite']['tf_id']=$this->params['named']['tf_id'];
		
		if(isset($this->data['ClientSite']['cf_id']) && $this->data['ClientSite']['cf_id']!='') $cf_id = $this->data['ClientSite']['cf_id'];	
		else if(isset($this->params['named']['cf_id']) && $this->params['named']['cf_id']!='') $cf_id = $this->request->data['ClientSite']['cf_id']=$this->params['named']['cf_id'];
		
		if(isset($this->data['ClientSite']['da_id']) && $this->data['ClientSite']['da_id']!='') $da_id = $this->data['ClientSite']['da_id'];	
		else if(isset($this->params['named']['da_id']) && $this->params['named']['da_id']!='') $da_id = $this->request->data['ClientSite']['da_id']=$this->params['named']['da_id'];
		
		if(isset($this->data['ClientSite']['gambling_site_id']) && $this->data['ClientSite']['gambling_site_id']!='') $gambling_site_id = $this->data['ClientSite']['gambling_site_id'];	
		else if(isset($this->params['named']['gambling_site_id']) && $this->params['named']['gambling_site_id']!='') $gambling_site_id = $this->request->data['ClientSite']['gambling_site_id']=$this->params['named']['gambling_site_id'];
		
		if(isset($this->data['ClientSite']['target_market_id']) && $this->data['ClientSite']['target_market_id']!='') $target_market_id = $this->data['ClientSite']['target_market_id'];	
		else if(isset($this->params['named']['target_market_id']) && $this->params['named']['target_market_id']!='') $target_market_id = $this->request->data['ClientSite']['target_market_id']=$this->params['named']['target_market_id'];
		
		if(isset($this->data['ClientSite']['include_domain']) && $this->data['ClientSite']['include_domain']!='') $include_domain = $this->data['ClientSite']['include_domain'];	
		else if(isset($this->params['named']['include_domain']) && $this->params['named']['include_domain']!='') $include_domain = $this->request->data['ClientSite']['include_domain']=$this->params['named']['include_domain'];
		
		if(isset($this->data['ClientSite']['provider_contact']) && $this->data['ClientSite']['provider_contact']!='') $provider_contact = $this->data['ClientSite']['provider_contact'];	
		else if(isset($this->params['named']['provider_contact']) && $this->params['named']['provider_contact']!='') $provider_contact = $this->request->data['ClientSite']['provider_contact']=$this->params['named']['provider_contact'];
		
		if(isset($this->data['ClientSite']['date_time_from']) && $this->data['ClientSite']['date_time_from']!='') $date_time_from = $this->data['ClientSite']['date_time_from'];	
		else if(isset($this->params['named']['date_time_from']) && $this->params['named']['date_time_from']!='') $date_time_from = $this->request->data['ClientSite']['date_time_from']=$this->params['named']['date_time_from'];
				
		if(isset($this->data['ClientSite']['date_time_to']) && $this->data['ClientSite']['date_time_to']!='') $date_time_to = $this->data['ClientSite']['date_time_to'];	
		else if(isset($this->params['named']['date_time_to']) && $this->params['named']['date_time_to']!='') $date_time_to = $this->request->data['ClientSite']['date_time_to']=$this->params['named']['date_time_to'];
		
		if(isset($this->data['ClientSite']['original_email_id']) && $this->data['ClientSite']['original_email_id']!='') $original_email_id = $this->data['ClientSite']['original_email_id'];	
		else if(isset($this->params['named']['original_email_id']) && $this->params['named']['original_email_id']!='') $original_email_id = $this->request->data['ClientSite']['original_email_id']=$this->params['named']['original_email_id'];
		
		if(isset($this->data['ClientSite']['employee_id']) && $this->data['ClientSite']['employee_id']!='') $employee_id = $this->data['ClientSite']['employee_id'];	
		else if(isset($this->params['named']['employee_id']) && $this->params['named']['employee_id']!='') $employee_id = $this->request->data['ClientSite']['employee_id']=$this->params['named']['employee_id'];		
		
		if(isset($this->data['ClientSite']['group_theme_id']) && $this->data['ClientSite']['group_theme_id']!='') $group_theme_id = $this->data['ClientSite']['group_theme_id'];	
		else if(isset($this->params['named']['group_theme_id']) && $this->params['named']['group_theme_id']!='') $group_theme_id = $this->request->data['ClientSite']['group_theme_id']=$this->params['named']['group_theme_id'];		
		
		if(isset($this->data['ClientSite']['group_language_id']) && $this->data['ClientSite']['group_language_id']!='') $group_language_id = $this->data['ClientSite']['group_language_id'];	
		else if(isset($this->params['named']['group_language_id']) && $this->params['named']['group_language_id']!='') $group_language_id = $this->request->data['ClientSite']['group_language_id']=$this->params['named']['group_language_id'];		
		
		if(isset($this->data['ClientSite']['tld']) && $this->data['ClientSite']['tld']!='') $tld = $this->data['ClientSite']['tld'];	
		else if(isset($this->params['named']['tld']) && $this->params['named']['tld']!='') $tld = $this->request->data['ClientSite']['tld']=$this->params['named']['tld'];		
		
		if(isset($this->data['ClientSite']['tested']) && $this->data['ClientSite']['tested']!='') $tested = $this->data['ClientSite']['tested'];	
		else if(isset($this->params['named']['tested']) && $this->params['named']['tested']!='') $tested = $this->request->data['ClientSite']['tested']=$this->params['named']['tested'];	
		
		if(isset($this->data['ClientSite']['waiting_approval']) && $this->data['ClientSite']['waiting_approval']!='') $waiting_approval = $this->data['ClientSite']['waiting_approval'];	
		else if(isset($this->params['named']['waiting_approval']) && $this->params['named']['waiting_approval']!='') $waiting_approval = $this->request->data['ClientSite']['waiting_approval']=$this->params['named']['waiting_approval'];
		
		if(isset($this->data['ClientSite']['multiple_keyword_id']) && $this->data['ClientSite']['multiple_keyword_id']!='') $multiple_keyword_id = $this->data['ClientSite']['multiple_keyword_id'];	
		else if(isset($this->params['named']['multiple_keyword_id']) && $this->params['named']['multiple_keyword_id']!='') $multiple_keyword_id = $this->request->data['ClientSite']['multiple_keyword_id']=$this->params['named']['multiple_keyword_id'];
		
		if(isset($this->data['ClientSite']['limit']) && $this->data['ClientSite']['limit']!='') $limit = $this->data['ClientSite']['limit'];	
		else if(isset($this->params['named']['limit']) && $this->params['named']['limit']!='') $limit = $this->request->data['ClientSite']['limit']=$this->params['named']['limit'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		//echo '<pre>';print_r($this->data['ClientSite']);
		
		if(!empty($client_id))
		{
			/*$find_pre=$this->ClientSiteRecord->find("first",array("conditions"=>array("ClientSiteRecord.client_id"=>$client_id),"order"=>"ClientSiteRecord.id DESC"));
			if(!empty($find_pre))
				$conditions['ClientSite.id > '] = $find_pre['ClientSiteRecord']['site_id'];*/
			$pagingArgs['client_id'] = $client_id;
			// check this in client_site_urls tables
			$client_site_urls=$this->ClientSiteUrl->find("all",array("conditions"=>array("ClientSiteUrl.client_id"=>$client_id)));
			$ids=array();
			if(!empty($client_site_urls))
			{
				foreach($client_site_urls as $client_site_url)
				{
					$ids[]=$client_site_url['ClientSiteUrl']['site_id'];
				}
			}
			$id_list=implode(',',$ids);
			if(!empty($ids))
			{
				if(count($ids)==1)
					$conditions['ClientSite.id <>'] = $id_list;
				else
					$conditions['ClientSite.id not'] = $ids;
			}
		}
		$this->set('matched_url','');
		if(!empty($url))
		{
			$find_id=$this->ClientSite->find("all",array("conditions"=>array("ClientSite.url like "=>'%'.$url.'%')));
			if(!empty($find_id) && count($find_id) > 1)
			{
				$temp_arr=array();
				foreach($find_id as $inn_id)
				{
					$temp_arr[]=$inn_id['ClientSite']['url'];
				}
				$temp_urls=implode("<br>",$temp_arr);
				$this->set('matched_url','Matched Urls are:<br> '.$temp_urls);
			}
			$s_id=$find_id[0]['ClientSite']['id'];
			if(isset($this->data['ClientSite']['include_domain']) && $this->data['ClientSite']['include_domain']=='1' && !empty($this->data['ClientSite']['include_domain']) )
			{
				$conditions['ClientSite.id >='] = $s_id;
				$pagingArgs['include_domain'] = 1;
			}
			else
				$conditions['ClientSite.id > '] = $s_id;
			$pagingArgs['url'] = $url;
		}
		if(!empty($article_price_from))
		{
			$conditions['ClientSite.article_price >='] = $article_price_from;
			$pagingArgs['article_price_from'] = $article_price_from;
		}
		if(!empty($article_price_to))
		{
			$conditions['ClientSite.article_price <='] = $article_price_to;
			$pagingArgs['article_price_to'] = $article_price_to;
		}
		if(!empty($article_duration_id))
		{
			$conditions['ClientSite.article_duration_id'] = $article_duration_id;
			$pagingArgs['article_duration_id'] = $article_duration_id;
		}
		if(!empty($home_page_link_price_from))
		{
			$conditions['ClientSite.home_page_link_price >='] = $home_page_link_price_from;
			$pagingArgs['home_page_link_price_from'] = $home_page_link_price_from;
		}
		if(!empty($home_page_link_price_to))
		{
			$conditions['ClientSite.home_page_link_price <='] = $home_page_link_price_to;
			$pagingArgs['home_page_link_price_to'] = $home_page_link_price_to;
		}
		if(!empty($language_id))
		{
			if(count($language_id)==1)
				$conditions['ClientSite.language_id'] = $language_id[0];
			else
				$conditions['ClientSite.language_id'] = $language_id;
			$pagingArgs['language_id'] = $language_id;
		}
		if(!empty($tf_id))
		{
			$conditions['ClientSite.tf_id >= '] = $tf_id;
			$pagingArgs['tf_id'] = $tf_id;
		}		
		if(!empty($cf_id))
		{
			$conditions['ClientSite.cf_id >= '] = $cf_id;
			$pagingArgs['cf_id'] = $cf_id;
		}	
		if(!empty($da_id))
		{
			$conditions['ClientSite.da_id >= '] = $da_id;
			$pagingArgs['da_id'] = $da_id;
		}
		if(!empty($provider_contact))
		{
			$conditions['ClientSite.provider_contact LIKE '] = '%'.$provider_contact.'%';
			$pagingArgs['provider_contact'] = $provider_contact;
		}
		if(!empty($availability_id))
		{
			$conditions['ClientSite.availability_id'] = $availability_id;
			$pagingArgs['availability_id'] = $availability_id;
		}
		if(!empty($theme_site_id))
		{
			if(count($theme_site_id)==1)
				$conditions['ClientSite.theme_site_id'] = $theme_site_id[0];
			else
				$conditions['ClientSite.theme_site_id'] = $theme_site_id;
			$pagingArgs['theme_site_id'] = $theme_site_id;
		}
		if(!empty($gambling_site_id))
		{
			$conditions['ClientSite.gambling_site_id'] = $gambling_site_id;
			$pagingArgs['gambling_site_id'] = $gambling_site_id;
		}
		if(!empty($accept_gambling_id))
		{
			$conditions['ClientSite.accept_gambling_id'] = $accept_gambling_id;
			$pagingArgs['accept_gambling_id'] = $accept_gambling_id;
		}
		if(!empty($accept_sport_betting_id))
		{
			$conditions['ClientSite.accept_sport_betting_id'] = $accept_sport_betting_id;
			$pagingArgs['accept_sport_betting_id'] = $accept_sport_betting_id;
		}
		if(!empty($gambling_site_id))
		{
			$conditions['ClientSite.gambling_site_id'] = $gambling_site_id;
			$pagingArgs['gambling_site_id'] = $gambling_site_id;
		}
		if(!empty($date_time_from))
		{
			$conditions['ClientSite.today_date >= '] = $date_time_from;
			$pagingArgs['date_time_from'] = $date_time_from;
		}
		if(!empty($date_time_to))
		{
			$conditions['ClientSite.today_date <= '] = $date_time_to;
			$pagingArgs['date_time_to'] = $date_time_to;
		}
		if(!empty($original_email_id))
		{
			$conditions['ClientSite.original_email_id'] = $original_email_id;
			$pagingArgs['original_email_id'] = $original_email_id;
		}
		if(!empty($employee_id))
		{
			$conditions['ClientSite.employee_id'] = $employee_id;
			$pagingArgs['employee_id'] = $employee_id;
		}
		if(!empty($target_market_id))
		{
			$conditions['ClientSite.target_market_id'] = $target_market_id;
			$pagingArgs['target_market_id'] = $target_market_id;
		}
		if(!empty($group_theme_id))
		{
			$rowtmp=$this->GroupTheme->find("first",array("conditions"=>array("GroupTheme.id"=>$group_theme_id)));
			$exp=explode(",",$rowtmp['GroupTheme']['theme_site_id']);
			if(count($exp)==1)
				$conditions['ClientSite.theme_site_id'] = $exp[0];
			else
				$conditions['ClientSite.theme_site_id'] = $exp;
			$pagingArgs['group_theme_id'] = $group_theme_id;
		}
		
		if(!empty($group_language_id))
		{
			$rowtmp=$this->GroupLanguage->find("first",array("conditions"=>array("GroupLanguage.id"=>$group_language_id)));
			$exp=explode(",",$rowtmp['GroupLanguage']['languages_id']);
			if(count($exp)==1)
				$conditions['ClientSite.language_id'] = $exp[0];
			else
				$conditions['ClientSite.language_id'] = $exp;
			$pagingArgs['group_language_id'] = $group_language_id;
		}
		if(!empty($tested))
		{
			$conditions['ClientSite.tested'] = '2';
			$pagingArgs['tested'] = $tested;
		}
		if(!empty($tld))
		{
			$conditions['ClientSite.url like '] = '%'.$tld;
			$pagingArgs['tld'] = $tld;
		}
		if(!empty($user_id))
		{
			$conditions['ClientSite.user_id'] = $user_id;
			$pagingArgs['user_id'] = $user_id;
		}
		if(!empty($waiting_approval))
		{
			$check_temp_sites=$this->TempSite->find("all",array("conditions"=>array("TempSite.user_id"=>$this->Auth->user('id')),"fields"=>array("site_id")));
			$site_id_arr=array();
			foreach($check_temp_sites as $check_temp_site)
			{
				$site_id_arr[]=$check_temp_site['TempSite']['site_id'];
			}
			if(!empty($site_id_arr))
			{
				$imp_site_id=implode(',',$site_id_arr);
				$conditions['ClientSite.id'] = $imp_site_id;
			}
			$pagingArgs['waiting_approval'] = $waiting_approval;
		}
		if(!empty($multiple_keyword_id))
		{
			$client_site_id_list=array();
			foreach($multiple_keyword_id as $multiple_keyword_id_only)
			{
				$site_text=$this->get_multiple_keyword($multiple_keyword_id_only);
				$find_sites=$this->ClientSite->find("all",array("conditions"=>array("ClientSite.url like "=>"%".$site_text."%"),"fields"=>array("ClientSite.id")));
				foreach($find_sites as $find_site)
				{
					if(!in_array($find_site,$client_site_id_list))
						$client_site_id_list[]=$find_site['ClientSite']['id'];
				}
			}
			//pr($client_site_id_list);
			if(count($client_site_id_list)==1)
			{
				$conditions['ClientSite.id'] = $client_site_id_list[0];
			}
			else
			{
				$imp_client_site_id=implode(',',$client_site_id_list);
				$conditions['ClientSite.id'] = $client_site_id_list;
			}
			$pagingArgs['multiple_keyword_id'] = $multiple_keyword_id;
		}
		if(!empty($limit))
		{
			$pagingArgs['limit'] = $limit;
		}
		
		/*if(isset($this->data['ClientSite']['remove_client']) && $this->data['ClientSite']['remove_client']=='1' && !empty($this->data['ClientSite']['client_id']) )
		{
			$res=$this->ClientSite->find("first",array("conditions"=>$conditions,"order"=>"ClientSite.id DESC"));
			if(!empty($res['ClientSite']['id']))
			{
				$client_arr['site_id']=$res['ClientSite']['id'];
				$client_arr['client_id']=$this->data['ClientSite']['client_id'];
				$client_arr['date_time']=date("Y-m-d H:i:s");
				$this->ClientSiteRecord->save($client_arr);
			}
		}*/
		//$limit=1000;
		$this->set("pagingArgs",$pagingArgs);	
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('ClientSite.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('client_sites', $rows);
		if(isset($this->request->params['named']['page']) && $this->request->params['named']['page'])
			$page_no=($this->request->params['named']['page']-1)*$limit;
		else
			$page_no=0;
		$this->set("page_no",$page_no);
		
		$this->params['page_title'] = "ClientSite";
		if($id != null){
		$this->ClientSite->id = $id;
		if (!$this->ClientSite->exists()) {
			throw new NotFoundException(__('Invalid ClientSite'));
		}
		}
		
	}
	public function admin_download_csv()
	{
		Configure::write('debug',0);
		$this->autoRender = false;
		$this->Site->recursive = 0;		
		
		if(isset($this->data['download']['search_client_id']) && $this->data['download']['search_client_id']!='') $search_client_id = $this->data['download']['search_client_id'];	
		else if(isset($this->params['named']['search_client_id']) && $this->params['named']['search_client_id']!='') $search_client_id = $this->request->data['download']['search_client_id']=$this->params['named']['search_client_id'];
		
		if(isset($this->data['download']['search_client_id']) && $this->data['download']['search_client_id']!='') $client_id = $this->data['download']['search_client_id'];	
		else if(isset($this->params['named']['client_id']) && $this->params['named']['client_id']!='') $client_id = $this->request->data['download']['search_client_id']=$this->params['named']['client_id'];
		
		if(isset($this->data['download']['search_user_id']) && $this->data['download']['search_user_id']!='') $user_id = $this->data['Clientdownload']['search_user_id'];	
		else if(isset($this->params['named']['user_id']) && $this->params['named']['user_id']!='') $user_id = $this->request->data['Clientdownload']['search_user_id']=$this->params['named']['user_id'];
		
		if(isset($this->data['download']['search_url']) && $this->data['download']['search_url']!='') $url = $this->data['download']['search_url'];	
		else if(isset($this->params['named']['url']) && $this->params['named']['url']!='') $url = $this->request->data['download']['search_url']=$this->params['named']['url'];
		
		if(isset($this->data['download']['search_article_price_from']) && $this->data['download']['search_article_price_from']!='') $article_price_from = $this->data['download']['search_article_price_from'];	
		else if(isset($this->params['named']['article_price_from']) && $this->params['named']['article_price_from']!='') $article_price_from =$this->request->data['download']['search_article_price_from']=$this->params['named']['article_price_from'];
		
		if(isset($this->data['download']['search_article_price_to']) && $this->data['download']['search_article_price_to']!='') $article_price_to = $this->data['download']['search_article_price_to'];	
		else if(isset($this->params['named']['article_price_to']) && $this->params['named']['article_price_to']!='') $article_price_to = $this->request->data['download']['search_article_price_to']=$this->params['named']['article_price_to'];
		
		if(isset($this->data['download']['search_article_duration_id']) && $this->data['download']['search_article_duration_id']!='') $article_duration_id = $this->data['download']['search_article_duration_id'];	
		else if(isset($this->params['named']['article_duration_id']) && $this->params['named']['article_duration_id']!='') $article_duration_id = $this->request->data['download']['search_article_duration_id']=$this->params['named']['article_duration_id'];
		
		if(isset($this->data['download']['search_home_page_link_price_from']) && $this->data['download']['search_home_page_link_price_from']!='') $home_page_link_price_from = $this->data['download']['search_home_page_link_price_from'];	
		else if(isset($this->params['named']['home_page_link_price_from']) && $this->params['named']['home_page_link_price_from']!='') $home_page_link_price_from = $this->request->data['download']['search_home_page_link_price_from']=$this->params['named']['home_page_link_price_from'];
		
		if(isset($this->data['download']['search_home_page_link_price_to']) && $this->data['download']['search_home_page_link_price_to']!='') $home_page_link_price_to = $this->data['download']['search_home_page_link_price_to'];	
		else if(isset($this->params['named']['home_page_link_price_to']) && $this->params['named']['home_page_link_price_to']!='') $home_page_link_price_to = $this->request->data['download']['search_home_page_link_price_to']=$this->params['named']['home_page_link_price_to'];
		if(isset($this->data['download']['search_language_id']) && $this->data['download']['search_language_id']!='') $language_id = $this->data['download']['search_language_id'];	
		else if(isset($this->params['named']['language_id']) && $this->params['named']['language_id']!='') $language_id = $this->request->data['download']['search_language_id']=$this->params['named']['language_id'];
		
		if(isset($this->data['download']['search_tf_id']) && $this->data['download']['search_tf_id']!='') $tf_id = $this->data['download']['search_tf_id'];	
		else if(isset($this->params['named']['tf_id']) && $this->params['named']['tf_id']!='') $tf_id =$this->request->data['download']['search_tf_id']=$this->params['named']['tf_id'];
		
		if(isset($this->data['download']['search_cf_id']) && $this->data['download']['search_cf_id']!='') $cf_id = $this->data['download']['search_cf_id'];	
		else if(isset($this->params['named']['cf_id']) && $this->params['named']['cf_id']!='') $cf_id =$this->request->data['download']['search_cf_id']=$this->params['named']['cf_id'];
		
		if(isset($this->data['download']['search_da_id']) && $this->data['download']['search_da_id']!='') $da_id = $this->data['download']['search_da_id'];	
		else if(isset($this->params['named']['da_id']) && $this->params['named']['da_id']!='') $da_id =$this->request->data['download']['search_da_id']=$this->params['named']['da_id'];
		
		if(isset($this->data['download']['search_provider_contact']) && $this->data['download']['search_provider_contact']!='') $provider_contact = $this->data['download']['search_provider_contact'];	
		else if(isset($this->params['named']['provider_contact']) && $this->params['named']['provider_contact']!='') $provider_contact = $this->request->data['download']['search_provider_contact']=$this->params['named']['provider_contact'];
		
		if(isset($this->data['download']['search_availability_id']) && $this->data['download']['search_availability_id']!='') $availability_id = $this->data['download']['search_availability_id'];	
		else if(isset($this->params['named']['availability_id']) && $this->params['named']['availability_id']!='') $availability_id = $this->request->data['download']['search_availability_id']=$this->params['named']['availability_id'];
		
		if(isset($this->data['download']['search_theme_site_id']) && $this->data['download']['search_theme_site_id']!='') $theme_site_id=$this->data['download']['search_theme_site_id'];	
		else if(isset($this->params['named']['theme_site_id']) && $this->params['named']['theme_site_id']!='') $theme_site_id = $this->request->data['download']['search_theme_site_id']=$this->params['named']['theme_site_id'];
		
		if(isset($this->data['download']['search_gambling_site_id']) && $this->data['download']['search_gambling_site_id']!='') $gambling_site_id = $this->data['download']['search_gambling_site_id'];	
		else if(isset($this->params['named']['gambling_site_id']) && $this->params['named']['gambling_site_id']!='') $gambling_site_id = $this->request->data['download']['search_gambling_site_id']=$this->params['named']['gambling_site_id'];
		
		if(isset($this->data['download']['search_accept_gambling_id']) && $this->data['download']['search_accept_gambling_id']!='') $accept_gambling_id = $this->data['download']['search_accept_gambling_id'];	
		else if(isset($this->params['named']['accept_gambling_id']) && $this->params['named']['accept_gambling_id']!='') $accept_gambling_id = $this->request->data['download']['search_accept_gambling_id']=$this->params['named']['accept_gambling_id'];
		
		if(isset($this->data['download']['search_accept_sport_betting_id']) && $this->data['download']['search_accept_sport_betting_id']!='') $accept_sport_betting_id = $this->data['download']['search_accept_sport_betting_id'];	
		else if(isset($this->params['named']['accept_sport_betting_id']) && $this->params['named']['accept_sport_betting_id']!='') $accept_sport_betting_id = $this->request->data['download']['search_accept_sport_betting_id']=$this->params['named']['accept_sport_betting_id'];
		
		if(isset($this->data['download']['search_date_time_from']) && $this->data['download']['search_date_time_from']!='') $date_time_from = $this->data['download']['search_date_time_from'];	
		else if(isset($this->params['named']['date_time_from']) && $this->params['named']['date_time_from']!='') $date_time_from = $this->request->data['download']['search_date_time_from']=$this->params['named']['date_time_from'];
				
		if(isset($this->data['download']['search_date_time_to']) && $this->data['download']['search_date_time_to']!='') $date_time_to = $this->data['download']['search_date_time_to'];	
		else if(isset($this->params['named']['date_time_to']) && $this->params['named']['date_time_to']!='') $date_time_to = $this->request->data['download']['search_date_time_to']=$this->params['named']['date_time_to'];
		
		if(isset($this->data['download']['search_original_email_id']) && $this->data['download']['search_original_email_id']!='') $original_email_id = $this->data['download']['search_original_email_id'];	
		else if(isset($this->params['named']['original_email_id']) && $this->params['named']['original_email_id']!='') $original_email_id = $this->request->data['download']['search_original_email_id']=$this->params['named']['original_email_id'];
		
		if(isset($this->data['download']['search_employee_id']) && $this->data['download']['search_employee_id']!='') $employee_id = $this->data['download']['search_employee_id'];	
		else if(isset($this->params['named']['employee_id']) && $this->params['named']['employee_id']!='') $employee_id = $this->request->data['download']['search_employee_id']=$this->params['named']['employee_id'];		
		
		if(isset($this->data['download']['search_target_market_id']) && $this->data['download']['search_target_market_id']!='') $target_market_id = $this->data['download']['search_target_market_id'];	
		else if(isset($this->params['named']['target_market_id']) && $this->params['named']['target_market_id']!='') $target_market_id = $this->request->data['download']['search_target_market_id']=$this->params['named']['target_market_id'];
		
		if(isset($this->data['download']['search_group_theme_id']) && $this->data['download']['search_group_theme_id']!='') $group_theme_id = $this->data['download']['search_group_theme_id'];			
		
		if(isset($this->data['download']['search_group_language_id']) && $this->data['download']['search_group_language_id']!='') $group_language_id = $this->data['download']['search_group_language_id'];
		
		if(isset($this->data['download']['search_waiting_approval']) && $this->data['download']['search_waiting_approval']!='') $waiting_approval = $this->data['download']['search_waiting_approval'];	
		else if(isset($this->params['named']['waiting_approval']) && $this->params['named']['waiting_approval']!='') $waiting_approval = $this->request->data['download']['search_waiting_approval']=$this->params['named']['waiting_approval'];		
		
		if(isset($this->data['download']['search_include_domain']) && $this->data['download']['search_include_domain']!='') $search_include_domain = $this->data['download']['search_include_domain'];	
		else if(isset($this->params['named']['search_include_domain']) && $this->params['named']['search_include_domain']!='') $search_include_domain = $this->request->data['download']['search_include_domain']=$this->params['named']['search_include_domain'];
		
		if(isset($this->data['download']['search_tld']) && $this->data['download']['search_tld']!='') $tld = $this->data['download']['search_tld'];	
		else if(isset($this->params['named']['search_tld']) && $this->params['named']['search_tld']!='') $tld = $this->request->data['download']['search_tld']=$this->params['named']['search_tld'];
		
		if(isset($this->data['download']['search_multiple_keyword_id']) && $this->data['download']['search_multiple_keyword_id']!='') $multiple_keyword_id = $this->data['download']['search_multiple_keyword_id'];	
		else if(isset($this->params['named']['search_multiple_keyword_id']) && $this->params['named']['search_multiple_keyword_id']!='') $multiple_keyword_id = $this->request->data['download']['search_multiple_keyword_id']=$this->params['named']['search_multiple_keyword_id'];
		
		if(isset($this->data['download']['search_tested']) && $this->data['download']['search_tested']!='') $search_tested = $this->data['download']['search_tested'];	
		else if(isset($this->params['named']['search_tested']) && $this->params['named']['search_tested']!='') $search_tested = $this->request->data['download']['search_tested']=$this->params['named']['search_tested'];
		
		//echo '<pre>';print_r($this->data['download']);
		
		$conditions = array(); 
		$pagingArgs = array();		
		
		if(!empty($search_client_id))
		{
			$pagingArgs['client_id'] = $search_client_id;
			
			$client_site_urls=$this->ClientSiteUrl->find("all",array("conditions"=>array("ClientSiteUrl.client_id"=>$search_client_id)));
			$ids=array();
			if(!empty($client_site_urls))
			{
				foreach($client_site_urls as $client_site_url)
				{
					$ids[]=$client_site_url['ClientSiteUrl']['site_id'];
				}
			}
			$id_list=implode(',',$ids);
			if(!empty($ids))
			{
				$conditions['Site.id <>'] = $id_list;
			}
		}	
		$this->set('matched_url','');	
		if(!empty($url))
		{
			$find_id=$this->ClientSite->find("all",array("conditions"=>array("ClientSite.url like "=>'%'.$url.'%')));
			if(count($find_id) > 1)
			{
				$temp_arr=array();
				foreach($find_id as $inn_id)
				{
					$temp_arr[]=$inn_id['ClientSite']['url'];
				}
				$temp_urls=implode("<br>",$temp_arr);
				$this->set('matched_url','Matched Urls are:<br> '.$temp_urls);
			}
			$s_id=$find_id[0]['ClientSite']['id'];
			if(isset($this->data['download']['search_include_domain']) && $this->data['download']['search_include_domain']=='1' && !empty($this->data['download']['search_include_domain']))
			{
				$conditions['Site.id >='] = $s_id;
				$pagingArgs['search_include_domain'] = 1;
			}
			else
				$conditions['Site.id > '] = $s_id;
			$pagingArgs['search_url'] = $search_url;
		}
		
		
		if(!empty($article_price_from))
		{
			$conditions['Site.article_price >='] = $article_price_from;
			$pagingArgs['article_price_from'] = $article_price_from;
		}
		if(!empty($article_price_to))
		{
			$conditions['Site.article_price <='] = $article_price_to;
			$pagingArgs['article_price_to'] = $article_price_to;
		}
		if(!empty($article_duration_id))
		{
			$conditions['Site.article_duration_id'] = $article_duration_id;
			$pagingArgs['article_duration_id'] = $article_duration_id;
		}
		if(!empty($home_page_link_price_from))
		{
			$conditions['Site.home_page_link_price >='] = $home_page_link_price_from;
			$pagingArgs['home_page_link_price_from'] = $home_page_link_price_from;
		}
		if(!empty($home_page_link_price_to))
		{
			$conditions['Site.home_page_link_price <='] = $home_page_link_price_to;
			$pagingArgs['home_page_link_price_to'] = $home_page_link_price_to;
		}
		if(!empty($language_id))
		{
			$language_id_arr=explode(",",$language_id);
			if(count($language_id_arr)==1)
				$conditions['Site.language_id'] = $language_id_arr[0];
			else
				$conditions['Site.language_id'] = $language_id_arr;
			$pagingArgs['language_id'] = $language_id;
		}
		if(!empty($tf_id))
		{
			$conditions['Site.tf_id >= '] = $tf_id;
			$pagingArgs['tf_id'] = $tf_id;
		}		
		if(!empty($cf_id))
		{
			$conditions['Site.cf_id >= '] = $cf_id;
			$pagingArgs['cf_id'] = $cf_id;
		}	
		if(!empty($da_id))
		{
			$conditions['Site.da_id >= '] = $da_id;
			$pagingArgs['da_id'] = $da_id;
		}
		if(!empty($provider_contact))
		{
			$conditions['Site.provider_contact LIKE '] = '%'.$provider_contact.'%';
			$pagingArgs['provider_contact'] = $provider_contact;
		}
		if(!empty($availability_id))
		{
			$conditions['Site.availability_id'] = $availability_id;
			$pagingArgs['availability_id'] = $availability_id;
		}
		if(!empty($theme_site_id))
		{
			$theme_site_id_arr=explode(",",$theme_site_id);
			if(count($theme_site_id_arr)==1)
				$conditions['Site.theme_site_id'] = $theme_site_id_arr[0];
			else
				$conditions['Site.theme_site_id'] = $theme_site_id_arr;
			$pagingArgs['theme_site_id'] = $theme_site_id;
		}
		if(!empty($gambling_site_id))
		{
			$conditions['Site.gambling_site_id'] = $gambling_site_id;
			$pagingArgs['gambling_site_id'] = $gambling_site_id;
		}
		if(!empty($accept_gambling_id))
		{
			$conditions['Site.accept_gambling_id'] = $accept_gambling_id;
			$pagingArgs['accept_gambling_id'] = $accept_gambling_id;
		}
		if(!empty($accept_sport_betting_id))
		{
			$conditions['Site.accept_sport_betting_id'] = $accept_sport_betting_id;
			$pagingArgs['accept_sport_betting_id'] = $accept_sport_betting_id;
		}
		if(!empty($gambling_site_id))
		{
			$conditions['Site.gambling_site_id'] = $gambling_site_id;
			$pagingArgs['gambling_site_id'] = $gambling_site_id;
		}
		if(!empty($date_time_from))
		{
			$conditions['Site.today_date >= '] = $date_time_from;
			$pagingArgs['date_time_from'] = $date_time_from;
		}
		if(!empty($date_time_to))
		{
			$conditions['Site.today_date <= '] = $date_time_to;
			$pagingArgs['date_time_to'] = $date_time_to;
		}
		if(!empty($original_email_id))
		{
			$conditions['Site.original_email_id'] = $original_email_id;
			$pagingArgs['original_email_id'] = $original_email_id;
		}
		if(!empty($employee_id))
		{
			$conditions['Site.employee_id'] = $employee_id;
			$pagingArgs['employee_id'] = $employee_id;
		}
		if(!empty($target_market_id))
		{
			$conditions['Site.target_market_id'] = $target_market_id;
			$pagingArgs['target_market_id'] = $target_market_id;
		}
		if(!empty($search_tested))
		{
			$conditions['Site.tested'] = $search_tested;
			$pagingArgs['tested'] = $search_tested;
		}
		if(!empty($tld))
		{
			$conditions['Site.url like '] = '%'.$tld;
			$pagingArgs['tld'] = $tld;
		}
		if(!empty($multiple_keyword_id))
		{
			$multiple_keyword_id=explode(",",$multiple_keyword_id);			
			
			$client_site_id_list=array();
			foreach($multiple_keyword_id as $multiple_keyword_id_only)
			{
				$site_text=$this->get_multiple_keyword($multiple_keyword_id_only);
				$site_text=trim($site_text);
				$find_sites=$this->Site->find("all",array("conditions"=>array("Site.url like "=>"%".$site_text."%"),"fields"=>array("Site.id")));
				foreach($find_sites as $find_site)
				{
					if(!in_array($find_site,$client_site_id_list))
						$client_site_id_list[]=$find_site['Site']['id'];
				}
			}
			//echo '<pre>';print_r($client_site_id_list);
			if(count($client_site_id_list)==1)
			{
				$conditions['Site.id'] = $client_site_id_list[0];
			}
			else
			{
				$imp_client_site_id=implode(',',$client_site_id_list);
				$conditions['Site.id'] = $client_site_id_list;
			}
		}
		if(!empty($group_theme_id))
		{
			$rowtmp=$this->GroupTheme->find("first",array("conditions"=>array("GroupTheme.id"=>$group_theme_id)));
			$exp=explode(",",$rowtmp['GroupTheme']['theme_site_id']);
			if(count($exp)==1)
				$conditions['Site.theme_site_id'] = $exp[0];
			else
				$conditions['Site.theme_site_id'] = $exp;
			$pagingArgs['group_theme_id'] = $group_theme_id;
		}
		
		if(!empty($group_language_id))
		{
			$rowtmp=$this->GroupLanguage->find("first",array("conditions"=>array("GroupLanguage.id"=>$group_language_id)));
			$exp=explode(",",$rowtmp['GroupLanguage']['languages_id']);
			if(count($exp)==1)
				$conditions['Site.language_id'] = $exp[0];
			else
				$conditions['Site.language_id'] = $exp;
			$pagingArgs['group_language_id'] = $group_language_id;
		}
		if(!empty($user_id))
		{
			$conditions['Site.user_id'] = $user_id;
			$pagingArgs['user_id'] = $user_id;
		}
		if(!empty($waiting_approval))
		{
			$check_temp_sites=$this->TempSite->find("all",array("conditions"=>array("TempSite.user_id"=>$this->Auth->user('id')),"fields"=>array("site_id")));
			$site_id_arr=array();
			foreach($check_temp_sites as $check_temp_site)
			{
				$site_id_arr[]=$check_temp_site['TempSite']['site_id'];
			}
			if(!empty($site_id_arr))
			{
				$imp_site_id=implode(',',$site_id_arr);
				$conditions['Site.id'] = $imp_site_id;
			}
			$pagingArgs['waiting_approval'] = $waiting_approval;
		}
		//echo '<pre>';print_r($conditions);die;
		$rows = $this->Site->find("all",array('order'=>array('Site.id'=>'DESC'),'conditions'=>$conditions));
		
		$namedate=__("Client-site")."-".date("m.d.y");
		$file_type = "vnd.ms-excel";
		$file_ending = "csv";
		header("Content-Type: application/$file_type");
		header("Content-Disposition: attachment; filename=$namedate.$file_ending");
		header("Pragma: no-cache");
		header("Expires: 0");
		$title = __("Client sites");
		$sep = ", ";
		$array_key=array(__("URL"),__("Currency"),__("Article Price"),__("Suggest Price"),__("Article Duration"),__("Language"),__("TF"),__("CF"),__("Provider Contact"),__("Theme of Site"),__("Tested"));
		//start of printing column names as names of MySQL fields
		for ($i = 0; $i < count($array_key); $i++)
		{
			echo $array_key[$i] . ", ";
		}
		print("\n");
		foreach($rows as $site)
		{
			$source_email=$this->get_source_email($site['Site']['source_email_id']);
			$currency=$this->get_currency($site['Site']['currency_id']);
			$article_duration=$this->get_article_duration($site['Site']['article_duration_id']);
			$theme_site=$this->get_theme_site($site['Site']['theme_site_id']);
			$language=$this->get_language($site['Site']['language_id']);
			$tf=$this->get_tf($site['Site']['tf_id']);
			$cf=$this->get_cf($site['Site']['cf_id']);
			$tested='No';
			if($site['Site']['tested']=='2')
				$tested='Yes';
			$suggest_price=0;	
			//Calculate suggest price
			$usd=Configure::read('USD');
			$euro=Configure::read('EURO');
			$pound=Configure::read('POUND');
			if($site['Site']['currency_id']==$usd)
			{
				if($site['Site']['article_price']<=10)
					$suggest_price=45;
				else if($site['Site']['article_price']>=11 && $site['Site']['article_price']<=20)
					$suggest_price=70;
				else if($site['Site']['article_price']>=21 && $site['Site']['article_price']<=30)
					$suggest_price=85;
				else if($site['Site']['article_price']>=31 && $site['Site']['article_price']<=40)
					$suggest_price=100;
				else if($site['Site']['article_price']>=41 && $site['Site']['article_price']<=50)
				{
					if($tf <=25)
						$suggest_price=130;
					else
						$suggest_price=145;
				}
				else if($site['Site']['article_price']>=51 && $site['Site']['article_price']<=60)
				{
					if($tf <=25)
						$suggest_price=140;
					else
						$suggest_price=155;
				}
				else if($site['Site']['article_price']>=61 && $site['Site']['article_price']<=70)
				{
					if($tf <=25)
						$suggest_price=155;
					else
						$suggest_price=165;
				}
				else if($site['Site']['article_price']>=71 && $site['Site']['article_price']<=80)
				{
					if($tf <=25)
						$suggest_price=170;
					else
						$suggest_price=180;
				}
				else if($site['Site']['article_price']>=81 && $site['Site']['article_price']<=90)
				{
					if($tf <=25)
						$suggest_price=180;
					else
						$suggest_price=195;
				}
				else if($site['Site']['article_price']>=91 && $site['Site']['article_price']<=100)
				{
					if($tf <=25)
						$suggest_price=195;
					else
						$suggest_price=215;
				}
				else if($site['Site']['article_price']>=101 && $site['Site']['article_price']<=120)
				{
					if($tf <=25)
						$suggest_price=225;
					else
						$suggest_price=240;
				}
				else if($site['Site']['article_price']>=121 && $site['Site']['article_price']<=140)
				{
					if($tf <=25)
						$suggest_price=245;
					else
						$suggest_price=270;
				}
				else if($site['Site']['article_price']>=141 && $site['Site']['article_price']<=160)
				{
					if($tf <=25)
						$suggest_price=280;
					else
						$suggest_price=295;
				}
				else if($site['Site']['article_price']>=161 && $site['Site']['article_price']<=200)
				{
					if($tf <=25)
						$suggest_price=315;
					else
						$suggest_price=355;
				}
				else if($site['Site']['article_price']>=201 && $site['Site']['article_price']<=250)
					$suggest_price=($site['Site']['article_price']*2 ) - 25;
				else if($site['Site']['article_price']>=251 && $site['Site']['article_price']<=300)
					$suggest_price=($site['Site']['article_price']*2 ) - 45;
				else if($site['Site']['article_price']>300)
					$suggest_price=($site['Site']['article_price']*2 ) - 75;
			}
			else if($site['Site']['currency_id']==$euro)
			{
				if($site['Site']['article_price']<=10)
					$suggest_price=45;
				else if($site['Site']['article_price']>=11 && $site['Site']['article_price']<=20)
					$suggest_price=75;
				else if($site['Site']['article_price']>=21 && $site['Site']['article_price']<=30)
					$suggest_price=90;
				else if($site['Site']['article_price']>=31 && $site['Site']['article_price']<=40)
					$suggest_price=115;
				else if($site['Site']['article_price']>=41 && $site['Site']['article_price']<=50)
				{
					if($tf <=25)
						$suggest_price=145;
					else
						$suggest_price=155;
				}
				else if($site['Site']['article_price']>=51 && $site['Site']['article_price']<=60)
				{
					if($tf <=25)
						$suggest_price=150;
					else
						$suggest_price=160;
				}
				else if($site['Site']['article_price']>=61 && $site['Site']['article_price']<=70)
				{
					if($tf <=25)
						$suggest_price=169;
					else
						$suggest_price=175;
				}
				else if($site['Site']['article_price']>=71 && $site['Site']['article_price']<=80)
				{
					if($tf <=25)
						$suggest_price=170;
					else
						$suggest_price=180;
				}
				else if($site['Site']['article_price']>=81 && $site['Site']['article_price']<=90)
				{
					if($tf <=25)
						$suggest_price=185;
					else
						$suggest_price=195;
				}
				else if($site['Site']['article_price']>=91 && $site['Site']['article_price']<=100)
				{
					if($tf <=25)
						$suggest_price=195;
					else
						$suggest_price=215;
				}
				else if($site['Site']['article_price']>=101 && $site['Site']['article_price']<=120)
				{
					if($tf <=25)
						$suggest_price=235;
					else
						$suggest_price=265;
				}
				else if($site['Site']['article_price']>=121 && $site['Site']['article_price']<=140)
				{
					if($tf <=25)
						$suggest_price=255;
					else
						$suggest_price=280;
				}
				else if($site['Site']['article_price']>=141 && $site['Site']['article_price']<=160)
				{
					if($tf <=25)
						$suggest_price=290;
					else
						$suggest_price=305;
				}
				else if($site['Site']['article_price']>=161 && $site['Site']['article_price']<=200)
				{
					if($tf <=25)
						$suggest_price=325;
					else
						$suggest_price=365;
				}
				else if($site['Site']['article_price']>=201 && $site['Site']['article_price']<=250)
					$suggest_price=($site['Site']['article_price']*2 ) - 25;
				else if($site['Site']['article_price']>=251 && $site['Site']['article_price']<=300)
					$suggest_price=($site['Site']['article_price']*2 ) - 45;
				else if($site['Site']['article_price']>300)
					$suggest_price=($site['Site']['article_price']*2 ) - 75;
			}
			else if($site['Site']['currency_id']==$pound)
			{
				if($site['Site']['article_price']<=10)
					$suggest_price=40;
				else if($site['Site']['article_price']>=11 && $site['Site']['article_price']<=20)
					$suggest_price=70;
				else if($site['Site']['article_price']>=21 && $site['Site']['article_price']<=30)
					$suggest_price=85;
				else if($site['Site']['article_price']>=31 && $site['Site']['article_price']<=40)
					$suggest_price=95;
				else if($site['Site']['article_price']>=41 && $site['Site']['article_price']<=50)
				{
					if($tf <=25)
						$suggest_price=115;
					else
						$suggest_price=125;
				}
				else if($site['Site']['article_price']>=51 && $site['Site']['article_price']<=60)
				{
					if($tf <=25)
						$suggest_price=135;
					else
						$suggest_price=145;
				}
				else if($site['Site']['article_price']>=61 && $site['Site']['article_price']<=70)
				{
					if($tf <=25)
						$suggest_price=150;
					else
						$suggest_price=155;
				}
				else if($site['Site']['article_price']>=71 && $site['Site']['article_price']<=80)
				{
					if($tf <=25)
						$suggest_price=160;
					else
						$suggest_price=175;
				}
				else if($site['Site']['article_price']>=81 && $site['Site']['article_price']<=90)
				{
					if($tf <=25)
						$suggest_price=175;
					else
						$suggest_price=180;
				}
				else if($site['Site']['article_price']>=91 && $site['Site']['article_price']<=100)
				{
					if($tf <=25)
						$suggest_price=190;
					else
						$suggest_price=200;
				}
				else if($site['Site']['article_price']>=101 && $site['Site']['article_price']<=120)
				{
					if($tf <=25)
						$suggest_price=225;
					else
						$suggest_price=240;
				}
				else if($site['Site']['article_price']>=121 && $site['Site']['article_price']<=140)
				{
					if($tf <=25)
						$suggest_price=245;
					else
						$suggest_price=260;
				}
				else if($site['Site']['article_price']>=141 && $site['Site']['article_price']<=160)
				{
					if($tf <=25)
						$suggest_price=270;
					else
						$suggest_price=295;
				}
				else if($site['Site']['article_price']>=161 && $site['Site']['article_price']<=200)
				{
					if($tf <=25)
						$suggest_price=315;
					else
						$suggest_price=355;
				}
				else if($site['Site']['article_price']>=201 && $site['Site']['article_price']<=250)
					$suggest_price=($site['Site']['article_price']*2 ) - 55;
				else if($site['Site']['article_price']>=251 && $site['Site']['article_price']<=300)
					$suggest_price=($site['Site']['article_price']*2 ) - 65;
				else if($site['Site']['article_price']>300)
					$suggest_price=($site['Site']['article_price']*2 ) - 100;
			}
			
			$schema_insert = "";
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$site['Site']['url'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$currency)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$site['Site']['article_price'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$suggest_price)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$article_duration)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$language)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$tf)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$cf)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$site['Site']['provider_contact'])).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$theme_site)).$sep;
			$schema_insert .= str_replace(',',';',str_replace(',',' ',$tested)).$sep;
			$schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
			$schema_insert .= "\t";
			print(trim($schema_insert));
			print "\n";
		}
		exit;		
	}
}
