<?php
App::uses('Controller', 'Controller');
class AppController extends Controller {
	public $components = array(
		'Session',
		'RequestHandler',
		'Auth' => array(
			'authenticate' => array(
				'User' => array(
				'userModel' => 'User'
				)
			)
		)
	);
	//public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public function beforeFilter() {
		
		if(isset($this->params['admin']) && $this->params['admin'] == 1)
		{
			$this->Auth->loginRedirect = array('controller' => 'pages','action' => 'dashboard','admin'=>true);
			$this->Auth->logoutRedirect = array('controller' => 'users', 'action' => 'login','admin'=>true);
		}
		else
		{
			/*$this->Auth->loginRedirect = array('controller' => 'members','action' => 'myaccount');
			$this->Auth->logoutRedirect = array('controller' => 'members', 'action' => 'login');
			$this->Auth->loginAction = array('controller' => 'members', 'action' => 'login','admin'=>false);*/
		}
		$this->loadmodel('ApplicationSetting');
		$application_setting=$this->ApplicationSetting->find("first",array("conditions"=>array("ApplicationSetting.id"=>"1")));		
		$this->set("applicationSetting",$application_setting['ApplicationSetting']);
		define("ADMINPAGELIMIT", $application_setting['ApplicationSetting']['result_limit']);
		
		$this->Auth->userScope = array('User.active' => 1);
		if(isset($this->params['prefix']) && $this->params['prefix'] == 'admin') {
			
			$logedUserData = $this->Auth->User();
			if(isset($logedUserData['type']) && $logedUserData['type']!=''){
				$this->layout = 'admin';
				$this->redirect(array('controller'=>'users','action' => 'login','admin'=>true));
				AuthComponent::$sessionKey = 'Auth.User';
			}else{
				$this->layout = 'admin';
				$this->Auth->allow('admin_resetpassword');
				AuthComponent::$sessionKey = 'Auth.User';
			}	
		} 
		else
		{	
			$this->Auth->allow('*');
			//AuthComponent::$sessionKey = 'Auth.Member';
		}
		
		//$this->_checkAdminUserPermission();
		//$this->headers();
	 	
		$this->set('loginUserId', $this->Auth->User('id'));
		
		if ($this->name == "Profiles") {
			$s = str_replace("step", "", $this->action);
			if($this->Session->read('Step.id') == 'true'){
				$this->redirect(array("controller" => "profiles", "action" => "step".($this->Session->read('Step.id')+2)), null, true);
			}
			else{
				if (abs($this->Session->read('Step.id') - $s) > 1 && $s != 0) {
					$this->redirect(array("controller" => "profiles", "action" => "step".($this->Session->read('Step.id')+1)), null, true);
				}
				
			}
		}
		
    }
	// If User is Super Admin
	public function checkAdmin(){
		if(($this->Session->read('Auth.User.role')) != 1){
			$this->redirect(Configure::read('Site.Url').'admin/users/profile');
		}
	}
	public function checkSubAdmin(){
		if(($this->Session->read('Auth.User.role') > 2)){
			$this->redirect(Configure::read('Site.Url').'admin');
		}
	}
	public function checkStaff(){
		if(($this->Session->read('Auth.User.role') > 3)){
			$this->redirect(Configure::read('Site.Url').'admin');
		}
	}
	public function checkNormal(){
		if(($this->Session->read('Auth.User.role') > 3)){
			$this->redirect(Configure::read('Site.Url').'admin');
		}
	}
	public function checkChecker(){
		if(($this->Session->read('Auth.User.role') > 4)){
			$this->redirect(Configure::read('Site.Url').'admin');
		}
	}
	public function checkSubAdminChecker(){
		$role=$this->Session->read('Auth.User.role');
		if(($this->Session->read('Auth.User.role') == 3) || (empty($role))){
			$this->redirect(Configure::read('Site.Url').'admin');
		}
	}
	public function userlogin(){
		if(($this->Session->read('Auth.User.role')) != 2){
			return $this->redirect(Configure::read('Site.Url').'users/login');
		}
	}	
	public function checkLogin(){
		$userid=$this->Session->read('Auth.User.id');
		if(empty($userid)){
			return $this->redirect(Configure::read('Site.Url').'admin');
		}
	}	
	public function uploadfile($imgdata,$folder_path,$model_name=NULL,$field=NULL,$insert_id=NULL){ 
		$imgname = "PROD_".microtime()."_".$imgdata['name'];
		$up_dir = WWW_ROOT . $folder_path;
    	//$target_path = $up_dir . DS . $imgname;
		
		$tempName      = $imgdata['tmp_name'];
		$realName      = str_replace(' ','_',$imgdata['name']);
		$realName      = str_replace('-','_',$realName);
		
		$file = $imgdata;
		$file_size = $file['size']; 
						
		$fileExtension = substr(strtolower($realName), strrpos($realName, '.') + 1);
		/*
		$rand_name     = md5(time());
		$rand_name     = rand(0,999999999);
		$full_name  = $rand_name.'.'.$fileExtension;*/
		
		//########################## Resize image to 900x900 max
		// check if previously this file exist.
		$this->loadmodel($model_name);
		$resr=$this->$model_name->find("count",array("conditions"=>array($model_name.".".$field=>$realName,$model_name.".id <>"=>$insert_id)));
		if($resr > 0)
		{
			$realName	=str_replace('.'.$fileExtension,'',$realName);
			$full_name  = $realName.'_'.$insert_id.'.'.$fileExtension;
			$realName =  $full_name;
		}
		App::import('Vendor', 'wineryupload');
		$handle = new Upload($imgdata);
		
		$up_dir = WWW_ROOT . $folder_path;
		$target_path = $up_dir . DS . $realName;
		@copy($imgdata['tmp_name'], $target_path);
		 return $realName;	
    }
	public function get_application_setting($key=NULL)
	{
		$this->loadmodel('ApplicationSetting');
		$application_setting=$this->ApplicationSetting->find("first",array("conditions"=>array("ApplicationSetting.id"=>"1")));
		if(!empty($key))
		{
			return $application_setting['ApplicationSetting'][$key];
		}
		else
		{
			$this->set("applicationSetting",$application_setting['ApplicationSetting']);
			return $application_setting['ApplicationSetting'][$key];
		}
	}
	public function get_countryname($id=NULL)
	{
		App::import("Model", "Country");
		$Country = new Country();  
		$countries=$Country->find("first",array("conditions"=>array("Country.id"=>$id)));   
		return $countries['Country']['name'];
	}
	public function get_statename($id=NULL)
	{
		App::import("Model", "State");
		$State = new State();  
		$states=$State->find("first",array("conditions"=>array("State.id"=>$id)));   
		return $states['State']['name'];
	}
	public function get_cityname($id=NULL)
	{
		App::import("Model", "City");
		$City = new City();  
		$cities=$City->find("first",array("conditions"=>array("City.id"=>$id)));   
		return $cities['City']['title'];
	}
	public function userdata($id=NULL)
	{
		App::import("Model", "User");
		$User = new User();  
		$users=$User->read(null, $id); 
		return $users;
	}
	public function getchecksum($MerchantId,$Amount,$OrderId ,$URL,$WorkingKey)
	{
		$str ="$MerchantId|$OrderId|$Amount|$URL|$WorkingKey";
		$adler = 1;
		$adler = $this->adler32($adler,$str);
		return $adler;
	}
	//functions
	function adler32($adler , $str)
	{
		$BASE = 65521 ;
		$s1 = $adler & 0xffff ;
		$s2 = ($adler >> 16) & 0xffff;
		for($i = 0 ; $i < strlen($str) ; $i++)
		{
			$s1 = ($s1 + Ord($str[$i])) % $BASE ;
			$s2 = ($s2 + $s1) % $BASE ;
		}
		return $this->leftshift($s2 , 16) + $s1;
	}
	//leftshift function
	function leftshift($str , $num)
	{
		$str = DecBin($str);
		for( $i = 0 ; $i < (64 - strlen($str)) ; $i++)
		$str = "0".$str ;
		for($i = 0 ; $i < $num ; $i++)
		{
			$str = $str."0";
			$str = substr($str , 1 ) ;
		}
		return $this->cdec($str) ;
	}
	//cdec function
	function cdec($num)
	{
		$dec=0;
		for ($n = 0 ; $n < strlen($num) ; $n++)
		{
			$temp = $num[$n] ;
			$dec = $dec + $temp*pow(2 , strlen($num) - $n - 1);
		}
		return $dec;	
	}
	function getRealIpAddr()
	{
		if (!empty($_SERVER['HTTP_CLIENT_IP']))   //check ip from share internet
		{
		  $ip=$_SERVER['HTTP_CLIENT_IP'];
		}
		elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))   //to check ip is pass from proxy
		{
		  $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
		}
		else
		{
		  $ip=$_SERVER['REMOTE_ADDR'];
		}
		return $ip;
	}
	public function checkUsername($email_id=NULL){
		App::import("Model", "User");
		$User = new User();  
		$users=$User->find("first",array("conditions"=>array("User.username"=>$email_id)));
		if(empty($users))
			return 'yes';
		else
			return 'no'; 
	}
	public function package_detail($id=NULL)
	{
		App::import("Model", "Package");
		$Package = new Package();  
		$packages=$Package->find("first",array('conditions' => array("Package.id"=>$id)));
		return $packages['Package'];
	}
	public function foldersize($dir){
		$count_size = 0;
		$count = 0;
		$dir_array = scandir($dir);
		foreach($dir_array as $key=>$filename){
			if($filename!=".." && $filename!="."){
				if(is_dir($dir."/".$filename)){
					$new_foldersize = $this->foldersize($dir."/".$filename);
					$count_size = $count_size + $new_foldersize;
				}else if(is_file($dir."/".$filename)){
					$count_size = $count_size + filesize($dir."/".$filename);
					$count++;
				}
			}
			
		}
		//$count_size=$count_size/1048576;
		return $count_size;
    }
	public function formatSizeUnits($bytes)
    {
        if ($bytes >= 1073741824)
        {
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        }
        elseif ($bytes >= 1048576)
        {
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        }
        elseif ($bytes >= 1024)
        {
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        }
        elseif ($bytes > 1)
        {
            $bytes = $bytes . ' bytes';
        }
        elseif ($bytes == 1)
        {
            $bytes = $bytes . ' byte';
        }
        else
        {
            $bytes = '0 bytes';
        }
        return $bytes;
	}
	public function folders()
	{
		$array=array("1"=>"Document","2"=>"Videos","3"=>"Images","4"=>"Key_Locker");
		return $array;
	}
	public function folder_title($id=NULL)
	{
		$array=array("1"=>"Document","2"=>"Videos","3"=>"Images","4"=>"Key_Locker");
		return $array[$id];
	}
	public function folder_list()
	{
		App::import("Model", "FolderList");
		$FolderList = new FolderList();  
		$folders=$FolderList->find("all");
		$array=array();
		foreach($folders as $folder_list)
		{
			$id=$folder_list['id'];
			if($folder_list['FolderList']['parent_folder_id']=='0')
				$array[$id]=$folder_list['FolderList']['id'];
			else
			{
				$parent_id=$folder_list['FolderList']['parent_folder_id'];
				$array[$parent_id][$id]=$folder_list['FolderList']['id'];
			}
		}
		return $array;
	}
	public function get_folder($folder_id)
	{
		App::import("Model", "FolderList");
		$FolderList = new FolderList();  
		$folders=$FolderList->find("first",array("conditions"=>array("FolderList.id"=>$folder_id)));
		if($folders['FolderList']['parent_folder_id']=='0')
			return $folders['FolderList']['folder_title'];
		else
		{
			$folders_inner=$FolderList->find("first",array("conditions"=>array("FolderList.id"=>$folders['FolderList']['parent_folder_id'])));
			return $folders_inner['FolderList']['folder_title'].'/'.$folders['FolderList']['folder_title'];
		}
	}
	public function get_folder_title($folder_id)
	{
		App::import("Model", "FolderList");
		$FolderList = new FolderList();  
		$folders=$FolderList->find("first",array("conditions"=>array("FolderList.id"=>$folder_id)));
		return $folders['FolderList']['folder_title'];
	}
	public function get_mime_type($file)
	{
			$mime_types = array(
					"pdf"=>"application/pdf"
					,"exe"=>"application/octet-stream"
					,"zip"=>"application/zip"
					,"docx"=>"application/msword"
					,"doc"=>"application/msword"
					,"xls"=>"application/vnd.ms-excel"
					,"ppt"=>"application/vnd.ms-powerpoint"
					,"gif"=>"image/gif"
					,"png"=>"image/png"
					,"jpeg"=>"image/jpg"
					,"jpg"=>"image/jpg"
					,"mp3"=>"audio/mpeg"
					,"wav"=>"audio/x-wav"
					,"mpeg"=>"video/mpeg"
					,"mpg"=>"video/mpeg"
					,"mpe"=>"video/mpeg"
					,"mov"=>"video/quicktime"
					,"avi"=>"video/x-msvideo"
					,"3gp"=>"video/3gpp"
					,"css"=>"text/css"
					,"jsc"=>"application/javascript"
					,"js"=>"application/javascript"
					,"php"=>"text/html"
					,"htm"=>"text/html"
					,"html"=>"text/html"
			);
			$extension = end(explode('.',strtolower($file)));
			return $mime_types[$extension];
	}
	public function force_download( $filename = '', $data = '' )
	{
		if( $filename == '' || $data == '' )
		{
			return false;
		}
		
		if( !file_exists( $data ) )
		{
			return false;
		}
	
		// Try to determine if the filename includes a file extension.
		// We need it in order to set the MIME type
		if( false === strpos( $filename, '.' ) )
		{
			return false;
		}
	
		// Grab the file extension
		$extension = strtolower( pathinfo( basename( $filename ), PATHINFO_EXTENSION ) );
	
		// our list of mime types
		$mime_types = array(
	
			'txt' => 'text/plain',
			'htm' => 'text/html',
			'html' => 'text/html',
			'php' => 'text/html',
			'css' => 'text/css',
			'js' => 'application/javascript',
			'json' => 'application/json',
			'xml' => 'application/xml',
			'swf' => 'application/x-shockwave-flash',
			'flv' => 'video/x-flv',
	
			// images
			'png' => 'image/png',
			'jpe' => 'image/jpeg',
			'jpeg' => 'image/jpeg',
			'jpg' => 'image/jpeg',
			'gif' => 'image/gif',
			'bmp' => 'image/bmp',
			'ico' => 'image/vnd.microsoft.icon',
			'tiff' => 'image/tiff',
			'tif' => 'image/tiff',
			'svg' => 'image/svg+xml',
			'svgz' => 'image/svg+xml',
	
			// archives
			'zip' => 'application/zip',
			'rar' => 'application/x-rar-compressed',
			'exe' => 'application/x-msdownload',
			'msi' => 'application/x-msdownload',
			'cab' => 'application/vnd.ms-cab-compressed',
	
			// audio/video
			'mp3' => 'audio/mpeg',
			'qt' => 'video/quicktime',
			'mov' => 'video/quicktime',
	
			// adobe
			'pdf' => 'application/pdf',
			'psd' => 'image/vnd.adobe.photoshop',
			'ai' => 'application/postscript',
			'eps' => 'application/postscript',
			'ps' => 'application/postscript',
	
			// ms office
			'doc' => 'application/msword',
			'rtf' => 'application/rtf',
			'xls' => 'application/vnd.ms-excel',
			'ppt' => 'application/vnd.ms-powerpoint',
	
			// open office
			'odt' => 'application/vnd.oasis.opendocument.text',
			'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
		);
	
		// Set a default mime if we can't find it
		if( !isset( $mime_types[$extension] ) )
		{
			$mime = 'application/octet-stream';
		}
		else
		{
			$mime = ( is_array( $mime_types[$extension] ) ) ? $mime_types[$extension][0] : $mime_types[$extension];
		}
			
		// Generate the server headers
		if( strstr( $_SERVER['HTTP_USER_AGENT'], "MSIE" ) )
		{
			header( 'Content-Type: "'.$mime.'"' );
			header( 'Content-Disposition: attachment; filename="'.$filename.'"' );
			header( 'Expires: 0' );
			header( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
			header( "Content-Transfer-Encoding: binary" );
			header( 'Pragma: public' );
			header( "Content-Length: ".filesize( $data ) );
		}
		else
		{
			header( "Pragma: public" );
			header( "Expires: 0" );
			header( "Cache-Control: must-revalidate, post-check=0, pre-check=0" );
			header( "Cache-Control: private", false );
			header( "Content-Type: ".$mime, true, 200 );
			header( 'Content-Length: '.filesize( $data ) );
			header( 'Content-Disposition: attachment; filename='.$filename);
			header( "Content-Transfer-Encoding: binary" );
		}
		readfile( $data );
		exit;
	
	}
	
	public function filename_byid($id=NULL)
	{
		App::import("Model", "FileManager");
		$FileManager = new FileManager();  
		$filemanager=$FileManager->find("first",array('conditions' => array("FileManager.id"=>$id)));
		return $filemanager['FileManager']['filename'];
	}
	public function site_setting(){
	  $this->layout = NULL;
	  App::import("Model", "User");
	  $User = new User();  
	  $userlist = $User->find('first',array('conditions'=>array('User.id'=>1)));
	  return $userlist['User'];
	  
	 }
	public function package_end_date($package_id){
		$this->layout = NULL;
		App::import("Model", "Package");
		$Package 	= 	new Package();  
		$packages 	= 	$Package->find('first',array('conditions'=>array('Package.id'=>$package_id)));
		$month		=	$packages['Package']['month'];
		$year		=	$packages['Package']['year'];
		$current_date=	date("Y-m-d");
		if($month >0)
			$current_date = date('Y-m-d', strtotime("+".$month." months", strtotime($current_date)));
		if($year >0)
			$effectiveDate = date('Y-m-d', strtotime("+".$year." years", strtotime($current_date)));
		
		return $effectiveDate;	
	}
	public function application_setting_key_val($key)
	{
		$arr=array("1"=>"calender_price","2"=>"document_price","3"=>"online_collage_price","4"=>"egift_price","5"=>"printed_scrapbooks_price","6"=>"other_feature_price");
		return $arr[$key];
	 }
	 public function applicationSetting()
	{	
		$this->loadmodel('ApplicationSetting');
		$application_setting=$this->ApplicationSetting->find("first",array("conditions"=>array("ApplicationSetting.id"=>"1")));	
		return $application_setting;
	}
	public function order_no()
	{
		$order_no = 'CABS-' . time();
		return $order_no;
	}
	function create_slug($string){
	   $slug=preg_replace('/[^A-Za-z0-9-]+/', '-', strtolower(trim($string)));
	   return $slug;
	}
	 //How to call another function
    public function imgresize($new_image_name=NULL){
        //create thumbnail of original image
        $source_image = WWW_ROOT . 'product/' . $new_image_name;
        $destination_thumb_path = WWW_ROOT . 'product/thumbs/' . $new_image_name;
        $this->imageresize($source_image, $destination_thumb_path, 500, 500);
    }
    public function imageresize($imagePath, $thumb_path, $destinationWidth, $destinationHeight) {
        // The file has to exist to be resized
        if (file_exists($imagePath)) {
            // Gather some info about the image
            $imageInfo = getimagesize($imagePath);
            // Find the intial size of the image
            $sourceWidth = $imageInfo[0];
            $sourceHeight = $imageInfo[1];
            if ($sourceWidth > $sourceHeight) {
                $temp = $destinationWidth;
                $destinationWidth = $destinationHeight;
                $destinationHeight = $temp;
            }
            // Find the mime type of the image
            $mimeType = $imageInfo['mime'];
            // Create the destination for the new image
            $destination = imagecreatetruecolor($destinationWidth, $destinationHeight);
            // Now determine what kind of image it is and resize it appropriately
            if ($mimeType == 'image/jpeg' || $mimeType == 'image/jpg' || $mimeType == 'image/pjpeg') {
                $source = imagecreatefromjpeg($imagePath);
                imagecopyresampled($destination, $source, 0, 0, 0, 0, $destinationWidth, $destinationHeight, $sourceWidth, $sourceHeight);
                imagejpeg($destination, $thumb_path);
            } else if ($mimeType == 'image/gif') {
                $source = imagecreatefromgif($imagePath);
                imagecopyresampled($destination, $source, 0, 0, 0, 0, $destinationWidth, $destinationHeight, $sourceWidth, $sourceHeight);
                imagegif($destination, $thumb_path);
            } else if ($mimeType == 'image/png' || $mimeType == 'image/x-png') {
                $source = imagecreatefrompng($imagePath);
                imagecopyresampled($destination, $source, 0, 0, 0, 0, $destinationWidth, $destinationHeight, $sourceWidth, $sourceHeight);
                imagepng($destination, $thumb_path);
            } else {
                $this->Session->setFlash(__('This image type is not supported.'), 'flash_error');
            }
            // Free up memory
           // imagedestroy($source);
            //imagedestroy($destination);
        }
		//echo 'hiiii';die;
    }
	public function generateRandomString($length = 10) {
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$charactersLength = strlen($characters);
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, $charactersLength - 1)];
		}
		return $randomString;
	}
	
	public function source_email_list()
	{
		App::import("Model", "SourceEmail");
		$SourceEmail = new SourceEmail();  
		$arr=array(""=>"Select");
		$result_list=$SourceEmail->find("all",array('conditions' => array('SourceEmail.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['SourceEmail']['id'];
			$arr[$id]=$result_temp['SourceEmail']['title'];
		}
		return $arr;
	}
	public function get_source_email($id=NULL)
	{
		App::import("Model", "SourceEmail");
		$SourceEmail = new SourceEmail();  
		$single_result=$SourceEmail->find("first",array("conditions"=>array("SourceEmail.id"=>$id)));	
		return trim($single_result['SourceEmail']['title']);
	}	
	public function currency_list()
	{
		App::import("Model", "Currency");
		$Currency = new Currency();  
		$arr=array(""=>"Select");
		$result_list=$Currency->find("all",array('conditions' => array('Currency.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['Currency']['id'];
			$arr[$id]=$result_temp['Currency']['title'];
		}
		return $arr;
	}
	public function get_currency($id=NULL)
	{
		App::import("Model", "Currency");
		$Currency = new Currency();  
		$single_result=$Currency->find("first",array("conditions"=>array("Currency.id"=>$id)));	
		return trim($single_result['Currency']['title']);
	}
	public function article_duration_list()
	{
		App::import("Model", "ArticleDuration");
		$ArticleDuration = new ArticleDuration();  
		$arr=array(""=>"");
		$result_list=$ArticleDuration->find("all",array('conditions' => array('ArticleDuration.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['ArticleDuration']['id'];
			$arr[$id]=$result_temp['ArticleDuration']['title'];
		}
		return $arr;
	}
	public function get_article_duration($id=NULL)
	{
		App::import("Model", "ArticleDuration");
		$ArticleDuration = new ArticleDuration();  
		$single_result=$ArticleDuration->find("first",array("conditions"=>array("ArticleDuration.id"=>$id)));	
		return trim($single_result['ArticleDuration']['title']);
	}	
	public function writing_price_list()
	{
		App::import("Model", "WritingPrice");
		$WritingPrice = new WritingPrice();  
		$arr=array(""=>"");
		$result_list=$WritingPrice->find("all",array('conditions' => array('WritingPrice.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['WritingPrice']['id'];
			$arr[$id]=$result_temp['WritingPrice']['title'];
		}
		return $arr;
	}
	public function get_writing_price($id=NULL)
	{
		App::import("Model", "WritingPrice");
		$WritingPrice = new WritingPrice();  
		$single_result=$WritingPrice->find("first",array("conditions"=>array("WritingPrice.id"=>$id)));	
		return trim($single_result['WritingPrice']['title']);
	}
	public function home_page_link_duration_list()
	{
		App::import("Model", "HomePageLinkDuration");
		$HomePageLinkDuration = new HomePageLinkDuration();  
		$arr=array(""=>"");
		$result_list=$HomePageLinkDuration->find("all",array('conditions' => array('HomePageLinkDuration.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['HomePageLinkDuration']['id'];
			$arr[$id]=$result_temp['HomePageLinkDuration']['title'];
		}
		return $arr;
	}
	public function get_home_page_link_duration($id=NULL)
	{
		App::import("Model", "HomePageLinkDuration");
		$HomePageLinkDuration = new HomePageLinkDuration();  
		$single_result=$HomePageLinkDuration->find("first",array("conditions"=>array("HomePageLinkDuration.id"=>$id)));	
		return trim($single_result['HomePageLinkDuration']['title']);
	}
	public function language_list()
	{
		App::import("Model", "Language");
		$Language = new Language();  
		$arr=array(""=>"");
		$result_list=$Language->find("all",array('conditions' => array('Language.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['Language']['id'];
			$arr[$id]=$result_temp['Language']['title'];
		}
		return $arr;
	}
	public function get_language($id=NULL)
	{
		App::import("Model", "Language");
		$Language = new Language();  
		$single_result=$Language->find("first",array("conditions"=>array("Language.id"=>$id)));	
		return trim($single_result['Language']['title']);
	}
	public function availability_list()
	{
		App::import("Model", "Availability");
		$Availability = new Availability();  
		$arr=array(""=>"");
		$result_list=$Availability->find("all",array('conditions' => array('Availability.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['Availability']['id'];
			$arr[$id]=$result_temp['Availability']['title'];
		}
		return $arr;
	}
	public function get_availability($id=NULL)
	{
		App::import("Model", "Availability");
		$Availability = new Availability();  
		$single_result=$Availability->find("first",array("conditions"=>array("Availability.id"=>$id)));	
		return trim($single_result['Availability']['title']);
	}
	public function theme_site_list()
	{
		App::import("Model", "ThemeSite");
		$ThemeSite = new ThemeSite();  
		$arr=array(""=>"");
		$result_list=$ThemeSite->find("all",array('conditions' => array('ThemeSite.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['ThemeSite']['id'];
			$arr[$id]=$result_temp['ThemeSite']['title'];
		}
		return $arr;
	}
	public function get_theme_site($id=NULL)
	{
		App::import("Model", "ThemeSite");
		$ThemeSite = new ThemeSite();  
		$single_result=$ThemeSite->find("first",array("conditions"=>array("ThemeSite.id"=>$id)));	
		return trim($single_result['ThemeSite']['title']);
	}	
	public function gambling_site_list()
	{
		App::import("Model", "GamblingSite");
		$GamblingSite = new GamblingSite();  
		$arr=array(""=>"");
		$result_list=$GamblingSite->find("all",array('conditions' => array('GamblingSite.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['GamblingSite']['id'];
			$arr[$id]=$result_temp['GamblingSite']['title'];
		}
		return $arr;
	}
	public function get_gambling_site($id=NULL)
	{
		App::import("Model", "GamblingSite");
		$GamblingSite = new GamblingSite();  
		$single_result=$GamblingSite->find("first",array("conditions"=>array("GamblingSite.id"=>$id)));	
		return trim($single_result['GamblingSite']['title']);
	}		
	public function accept_gambling_list()
	{
		App::import("Model", "AcceptGambling");
		$AcceptGambling = new AcceptGambling();  
		$arr=array(""=>"");
		$result_list=$AcceptGambling->find("all",array('conditions' => array('AcceptGambling.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['AcceptGambling']['id'];
			$arr[$id]=$result_temp['AcceptGambling']['title'];
		}
		return $arr;
	}
	public function get_accept_gambling($id=NULL)
	{
		App::import("Model", "AcceptGambling");
		$AcceptGambling = new AcceptGambling();  
		$single_result=$AcceptGambling->find("first",array("conditions"=>array("AcceptGambling.id"=>$id)));	
		return trim($single_result['AcceptGambling']['title']);
	}		
	public function accept_sport_betting_list()
	{
		App::import("Model", "AcceptSportsBetting");
		$AcceptSportsBetting = new AcceptSportsBetting();  
		$arr=array(""=>"");
		$result_list=$AcceptSportsBetting->find("all",array('conditions' => array('AcceptSportsBetting.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['AcceptSportsBetting']['id'];
			$arr[$id]=$result_temp['AcceptSportsBetting']['title'];
		}
		return $arr;
	}
	public function get_accept_sport_betting($id=NULL)
	{
		App::import("Model", "AcceptSportsBetting");
		$AcceptSportsBetting = new AcceptSportsBetting();  
		$single_result=$AcceptSportsBetting->find("first",array("conditions"=>array("AcceptSportsBetting.id"=>$id)));	
		return trim($single_result['AcceptSportsBetting']['title']);
	}			
	public function original_email_list()
	{
		App::import("Model", "OriginalEmail");
		$OriginalEmail = new OriginalEmail();  
		$arr=array(""=>"");
		$result_list=$OriginalEmail->find("all",array('conditions' => array('OriginalEmail.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['OriginalEmail']['id'];
			$arr[$id]=$result_temp['OriginalEmail']['title'];
		}
		return $arr;
	}
	public function get_original_email($id=NULL)
	{
		App::import("Model", "OriginalEmail");
		$OriginalEmail = new OriginalEmail();  
		$single_result=$OriginalEmail->find("first",array("conditions"=>array("OriginalEmail.id"=>$id)));	
		return trim($single_result['OriginalEmail']['title']);
	}	
	public function employee_list()
	{
		App::import("Model", "Employee");
		$Employee = new Employee();  
		$arr=array(""=>"");
		$result_list=$Employee->find("all",array('conditions' => array('Employee.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['Employee']['id'];
			$arr[$id]=$result_temp['Employee']['title'];
		}
		return $arr;
	}
	public function get_employee($id=NULL)
	{
		App::import("Model", "Employee");
		$Employee = new Employee();  
		$single_result=$Employee->find("first",array("conditions"=>array("Employee.id"=>$id)));	
		return trim($single_result['Employee']['title']);
	}	
	public function target_market_list()
	{
		App::import("Model", "TargetMarket");
		$TargetMarket = new TargetMarket();  
		$arr=array(""=>"");
		$result_list=$TargetMarket->find("all",array('conditions' => array('TargetMarket.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['TargetMarket']['id'];
			$arr[$id]=$result_temp['TargetMarket']['title'];
		}
		return $arr;
	}
	public function get_target_market($id=NULL)
	{
		App::import("Model", "TargetMarket");
		$TargetMarket = new TargetMarket();  
		$single_result=$TargetMarket->find("first",array("conditions"=>array("TargetMarket.id"=>$id)));	
		return trim($single_result['TargetMarket']['title']);
	}
	public function client_list()
	{
		App::import("Model", "Client");
		$Client = new Client();  
		$arr=array(""=>"");
		$result_list=$Client->find("all",array('conditions' => array('Client.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['Client']['id'];
			$arr[$id]=$result_temp['Client']['title'];
		}
		return $arr;
	}
	public function get_client($id=NULL)
	{
		App::import("Model", "Client");
		$Client = new Client();  
		$single_result=$Client->find("first",array("conditions"=>array("Client.id"=>$id)));	
		return trim($single_result['Client']['title']);
	}
	public function get_client_detail($id=NULL)
	{
		App::import("Model", "Client");
		$Client = new Client();  
		$single_result=$Client->find("first",array("conditions"=>array("Client.id"=>$id)));	
		return $single_result['Client'];
	}
	public function contact_way_list()
	{
		App::import("Model", "ContactWay");
		$ContactWay = new ContactWay();  
		$arr=array(""=>"");
		$result_list=$ContactWay->find("all",array('conditions' => array('ContactWay.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['ContactWay']['id'];
			$arr[$id]=$result_temp['ContactWay']['title'];
		}
		return $arr;
	}
	public function get_contact_way($id=NULL)
	{
		App::import("Model", "ContactWay");
		$ContactWay = new ContactWay();  
		$single_result=$ContactWay->find("first",array("conditions"=>array("ContactWay.id"=>$id)));	
		return trim($single_result['ContactWay']['title']);
	}	
	public function error_list()
	{
		App::import("Model", "EmployeeError");
		$EmployeeError = new EmployeeError();  
		$arr=array(""=>"");
		$result_list=$EmployeeError->find("all",array('conditions' => array('EmployeeError.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['EmployeeError']['id'];
			$arr[$id]=$result_temp['EmployeeError']['title'];
		}
		return $arr;
	}
	public function get_error($id=NULL)
	{
		App::import("Model", "EmployeeError");
		$EmployeeError = new EmployeeError();  
		$single_result=$EmployeeError->find("first",array("conditions"=>array("EmployeeError.id"=>$id)));	
		return trim($single_result['EmployeeError']['title']);
	}	
	public function error_type_list()
	{
		App::import("Model", "ErrorType");
		$ErrorType = new ErrorType();  
		$arr=array(""=>"");
		$result_list=$ErrorType->find("all",array('conditions' => array('ErrorType.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['ErrorType']['id'];
			$arr[$id]=$result_temp['ErrorType']['title'];
		}
		return $arr;
	}
	public function get_error_type($id=NULL)
	{
		App::import("Model", "ErrorType");
		$ErrorType = new ErrorType();  
		$single_result=$ErrorType->find("first",array("conditions"=>array("ErrorType.id"=>$id)));	
		return trim($single_result['ErrorType']['title']);
	}
	public function status_employee_list()
	{
		App::import("Model", "StatusEmployee");
		$StatusEmployee = new StatusEmployee();  
		$arr=array(""=>"");
		$result_list=$StatusEmployee->find("all",array('conditions' => array('StatusEmployee.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['StatusEmployee']['id'];
			$arr[$id]=$result_temp['StatusEmployee']['title'];
		}
		return $arr;
	}
	public function get_status_employee($id=NULL)
	{
		App::import("Model", "StatusEmployee");
		$StatusEmployee = new StatusEmployee();  
		$single_result=$StatusEmployee->find("first",array("conditions"=>array("StatusEmployee.id"=>$id)));	
		return trim($single_result['StatusEmployee']['title']);
	}
	public function operator_list()
	{
		App::import("Model", "User");
		$User = new User();  
		$arr=array(""=>"");
		$result_list=$User->find("all",array('conditions' => array('User.status' => 1),'fields' => array('id', 'name')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['User']['id'];
			$arr[$id]=$result_temp['User']['name'];
		}
		return $arr;
	}
	public function get_operator($id=NULL)
	{
		App::import("Model", "User");
		$User = new User();  
		$single_result=$User->find("first",array("conditions"=>array("User.id"=>$id)));	
		return trim($single_result['User']['name']);
	}
	public function tf_list()
	{
		$arr=array(""=>"");
		for($i = 0; $i <= 100; $i++)
			$arr[$i]=( $i < 10 ? "0{$i}" : $i );
		return $arr;
	}
	public function get_tf($id=NULL)
	{
		$arr=array();
		for($i = 0; $i <= 100; $i++)
			$arr[$i]=( $i < 10 ? "0{$i}" : $i );
		return $arr[$id];
	}
	public function cf_list()
	{
		$arr=array(""=>"");
		for($i = 0; $i <= 100; $i++)
			$arr[$i]=( $i < 10 ? "0{$i}" : $i );
		return $arr;
	}
	public function get_cf($id=NULL)
	{
		$arr=array();
		for($i = 0; $i <= 100; $i++)
			$arr[$i]=( $i < 10 ? "0{$i}" : $i );
		return $arr[$id];
	}
	public function da_list()
	{
		$arr=array(""=>"");
		for($i = 0; $i <= 100; $i++)
			$arr[$i]=( $i < 10 ? "0{$i}" : $i );
		return $arr;
	}
	public function get_da($id=NULL)
	{
		$arr=array();
		for($i = 0; $i <= 100; $i++)
			$arr[$i]=( $i < 10 ? "0{$i}" : $i );
		return $arr[$id];
	}
	public function get_source_email_id($title=NULL)
	{
		App::import("Model", "SourceEmail");
		$SourceEmail = new SourceEmail();  
		$single_result=$SourceEmail->find("first",array("conditions"=>array("SourceEmail.title"=>$title)));	
		return trim($single_result['SourceEmail']['id']);
	}
	public function get_currency_id($title=NULL)
	{
		App::import("Model", "Currency");
		$Currency = new Currency();  
		$single_result=$Currency->find("first",array("conditions"=>array("Currency.title"=>$title)));	
		return trim($single_result['Currency']['id']);
	}
	public function get_article_duration_id($title=NULL)
	{
		App::import("Model", "ArticleDuration");
		$ArticleDuration = new ArticleDuration();  
		$single_result=$ArticleDuration->find("first",array("conditions"=>array("ArticleDuration.title"=>$title)));	
		return trim($single_result['ArticleDuration']['id']);
	}
	public function get_writing_price_id($title=NULL)
	{
		App::import("Model", "WritingPrice");
		$WritingPrice = new WritingPrice();  
		$single_result=$WritingPrice->find("first",array("conditions"=>array("WritingPrice.title"=>$title)));	
		return trim($single_result['WritingPrice']['id']);
	}
	public function get_home_page_link_duration_id($title=NULL)
	{
		App::import("Model", "HomePageLinkDuration");
		$HomePageLinkDuration = new HomePageLinkDuration();  
		$single_result=$HomePageLinkDuration->find("first",array("conditions"=>array("HomePageLinkDuration.title"=>$title)));	
		return trim($single_result['HomePageLinkDuration']['id']);
	}	
	public function get_provider_payment_status_id($title=NULL)
	{
		App::import("Model", "ProviderPaymentStatus");
		$ProviderPaymentStatus = new ProviderPaymentStatus();  
		$single_result=$ProviderPaymentStatus->find("first",array("conditions"=>array("ProviderPaymentStatus.title"=>$title)));	
		return trim($single_result['ProviderPaymentStatus']['id']);
	}
	public function link_status_list()
	{
		App::import("Model", "LinkStatus");
		$arr=array(""=>"");
		$LinkStatus = new LinkStatus();  
		$result_list=$LinkStatus->find("all",array("conditions"=>array("LinkStatus.status" => 1),'fields' => array('id', 'title')));	
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['LinkStatus']['id'];
			$arr[$id]=$result_temp['LinkStatus']['title'];
		}
		return $arr;
	}
	public function get_link_status_id($title=NULL)
	{
		App::import("Model", "LinkStatus");
		$LinkStatus = new LinkStatus();  
		$single_result=$LinkStatus->find("first",array("conditions"=>array("LinkStatus.title"=>$title)));	
		return trim($single_result['LinkStatus']['id']);
	}
	public function get_tf_id($title=NULL)
	{
		$arr=array();
		for($i = 0; $i <= 100; $i++)
		{
			$val=( $i < 10 ? "0{$i}" : $i );
			if($val==$title)
			{
				return $i;
				break;
			}
		}
	}
	public function get_cf_id($title=NULL)
	{
		$arr=array();
		for($i = 0; $i <= 100; $i++)
		{
			$val=( $i < 10 ? "0{$i}" : $i );
			if($val==$title)
			{
				return $i;
				break;
			}
		}
	}
	public function get_da_id($title=NULL)
	{
		$arr=array();
		for($i = 0; $i <= 100; $i++)
		{
			$val=( $i < 10 ? "0{$i}" : $i );
			if($val==$title)
			{
				return $i;
				break;
			}
		}
	}
	public function get_availability_id($title=NULL)
	{
		App::import("Model", "Availability");
		$Availability = new Availability();  
		$single_result=$Availability->find("first",array("conditions"=>array("Availability.title"=>$title)));	
		return trim($single_result['Availability']['id']);
	}
	public function get_theme_site_id($title=NULL)
	{
		App::import("Model", "ThemeSite");
		$ThemeSite = new ThemeSite();  
		$single_result=$ThemeSite->find("first",array("conditions"=>array("ThemeSite.title"=>$title)));	
		return trim($single_result['ThemeSite']['id']);
	}
	public function get_gambling_site_id($title=NULL)
	{
		App::import("Model", "GamblingSite");
		$GamblingSite = new GamblingSite();  
		$single_result=$GamblingSite->find("first",array("conditions"=>array("GamblingSite.title"=>$title)));	
		return trim($single_result['GamblingSite']['id']);
	}
	public function get_accept_gambling_id($title=NULL)
	{
		App::import("Model", "AcceptGambling");
		$AcceptGambling = new AcceptGambling();  
		$single_result=$AcceptGambling->find("first",array("conditions"=>array("AcceptGambling.title"=>$title)));	
		return trim($single_result['AcceptGambling']['id']);
	}
	public function get_accept_sport_betting_id($title=NULL)
	{
		App::import("Model", "AcceptSportsBetting");
		$AcceptSportsBetting = new AcceptSportsBetting();  
		$single_result=$AcceptSportsBetting->find("first",array("conditions"=>array("AcceptSportsBetting.title"=>$title)));	
		return trim($single_result['AcceptSportsBetting']['id']);
	}
	public function get_language_id($title=NULL)
	{
		App::import("Model", "Language");
		$Language = new Language();  
		$single_result=$Language->find("first",array("conditions"=>array("Language.title"=>$title)));	
		return trim($single_result['Language']['id']);
	}
	public function get_contact_way_id($title=NULL)
	{
		App::import("Model", "ContactWay");
		$ContactWay = new ContactWay();  
		$single_result=$ContactWay->find("first",array("conditions"=>array("ContactWay.title"=>$title)));	
		return trim($single_result['ContactWay']['id']);
	}
	public function get_original_email_id($title=NULL)
	{
		App::import("Model", "OriginalEmail");
		$OriginalEmail = new OriginalEmail();  
		$single_result=$OriginalEmail->find("first",array("conditions"=>array("OriginalEmail.title"=>$title)));	
		return trim($single_result['OriginalEmail']['id']);
	}
	public function get_target_market_id($title=NULL)
	{
		App::import("Model", "TargetMarket");
		$TargetMarket = new TargetMarket();  
		$single_result=$TargetMarket->find("first",array("conditions"=>array("TargetMarket.title"=>$title)));	
		return trim($single_result['TargetMarket']['id']);
	}
	public function get_employee_id($title=NULL)
	{
		App::import("Model", "Employee");
		$Employee = new Employee();  
		$single_result=$Employee->find("first",array("conditions"=>array("Employee.title"=>$title)));	
		return trim($single_result['Employee']['id']);
	}
	public function get_employee_error_id($title=NULL)
	{
		App::import("Model", "EmployeeError");
		$EmployeeError = new EmployeeError();  
		$single_result=$EmployeeError->find("first",array("conditions"=>array("EmployeeError.title"=>$title)));	
		return trim($single_result['EmployeeError']['id']);
	}
	public function get_error_type_id($title=NULL)
	{
		App::import("Model", "ErrorType");
		$ErrorType = new ErrorType();  
		$single_result=$ErrorType->find("first",array("conditions"=>array("ErrorType.title"=>$title)));	
		return trim($single_result['ErrorType']['id']);
	}
	public function get_status_employee_id($title=NULL)
	{
		App::import("Model", "StatusEmployee");
		$StatusEmployee = new StatusEmployee();  
		$single_result=$StatusEmployee->find("first",array("conditions"=>array("StatusEmployee.title"=>$title)));	
		return trim($single_result['StatusEmployee']['id']);
	}
	public function get_site($id=NULL)
	{
		App::import("Model", "Site");
		$Site = new Site();  
		$single_result=$Site->find("first",array("conditions"=>array("Site.id"=>$id)));	
		return $single_result['Site'];
	}
	public function get_user_id($username=NULL)
	{
		App::import("Model", "User");
		$User = new User();  
		$single_result=$User->find("first",array("conditions"=>array("User.username"=>$username)));	
		return $single_result['User']['id'];
	}
	public function array_column(array $input, $columnKey, $indexKey = null) {
        $array = array();
        foreach ($input as $value) {
            if ( !array_key_exists($columnKey, $value)) {
                trigger_error("Key \"$columnKey\" does not exist in array");
                return false;
            }
            if (is_null($indexKey)) {
                $array[] = $value[$columnKey];
            }
            else {
                if ( !array_key_exists($indexKey, $value)) {
                    trigger_error("Key \"$indexKey\" does not exist in array");
                    return false;
                }
                if ( ! is_scalar($value[$indexKey])) {
                    trigger_error("Key \"$indexKey\" does not contain scalar value");
                    return false;
                }
                $array[$value[$indexKey]] = $value[$columnKey];
            }
        }
        return $array;
	}
	public function get_deal_input_detail($id=NULL)
	{
		App::import("Model", "DealInput");
		$DealInput = new DealInput();  
		$single_result=$DealInput->find("first",array("conditions"=>array("DealInput.id"=>$id)));	
		return $single_result;
	}
	public function get_search_type($id=NULL)
	{
		App::import("Model", "SearchType");
		$SearchType = new SearchType();  
		$single_result=$SearchType->find("first",array("conditions"=>array("SearchType.id"=>$id)));	
		return trim($single_result['SearchType']['title']);
	}
	public function get_link_status($id=NULL)
	{
		App::import("Model", "LinkStatus");
		$LinkStatus = new LinkStatus();  
		$single_result=$LinkStatus->find("first",array("conditions"=>array("LinkStatus.id"=>$id)));	
		return trim($single_result['LinkStatus']['title']);
	}	
	public function get_employee_time($id=NULL)
	{
		$arr=array();
		$count=1;
		for($i = 0; $i < 24; $i++)
		{
			$arr[$count]=date("H:i:s", strtotime("$i:00"));
			$count++;
			$arr[$count]=date("H:i:s", strtotime("$i:30"));
			$count++;
		}
		return $arr[$id];
	}
	public function multiple_keyword_list()
	{
		App::import("Model", "MultipleKeyword");
		$MultipleKeyword = new MultipleKeyword();  
		$arr=array(""=>"");
		$result_list=$MultipleKeyword->find("all",array('conditions' => array('MultipleKeyword.status' => 1),'fields' => array('id', 'title')));
		foreach($result_list as $result_temp)
		{
			$id=$result_temp['MultipleKeyword']['id'];
			$arr[$id]=$result_temp['MultipleKeyword']['title'];
		}
		return $arr;
	}
	public function get_multiple_keyword($id=NULL)
	{
		App::import("Model", "MultipleKeyword");
		$MultipleKeyword = new MultipleKeyword();  
		$single_result=$MultipleKeyword->find("first",array("conditions"=>array("MultipleKeyword.id"=>$id)));	
		return trim($single_result['MultipleKeyword']['title']);
	}
}